<?php
/*======================================================================*\
|| #################################################################### ||
|| # Country Flags for XenForo                                        # ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright  2015 Snog. All Rights Reserved.                      # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| #                     http://snogssite.com                         # ||
|| #################################################################### ||
\*======================================================================*/

require_once realpath(__DIR__ . '/Includes/Reader.php'); 
require_once realpath(__DIR__ . '/Includes/Reader/Decoder.php'); 
require_once realpath(__DIR__ . '/Includes/Reader/InvalidDatabaseException.php'); 
require_once realpath(__DIR__ . '/Includes/Reader/Metadata.php');
require_once realpath(__DIR__ . '/Includes/Reader/Util.php');
use Countryflags\Db\Reader;

class Snog_CountryFlags_Listener_Visitor 
{
	public static function visitor(&$visitor) 
	{
		$somecontent = '';
		if($visitor['user_id'] > 0)
		{
			$ipaddress = 'UNKNOWN';
			$tempaddress = array();
			$user_flag = 'A1';
			if(XenForo_Application::getOptions()->snog_countryflags_log) $somecontent .= 'User ID: ' . $visitor['user_id'];
			if(!empty($_SERVER['HTTP_CLIENT_IP']))
			{
				$ipaddress = $_SERVER['HTTP_CLIENT_IP'];
				if(XenForo_Application::getOptions()->snog_countryflags_log) $somecontent .= ' ::- CLIENT IP: ' . $_SERVER['HTTP_CLIENT_IP'];
    			}

			if(!self::isvalid_ip($ipaddress) && !empty($_SERVER['REMOTE_ADDR']))
			{
				$ipaddress = XenForo_Helper_Ip::convertIpBinaryToString(XenForo_Helper_Ip::getBinaryIp());
			}

			if(!empty($_SERVER['HTTP_FORWARDED_FOR']))
			{
				$ipaddress = $_SERVER['HTTP_FORWARDED_FOR'];
				if(XenForo_Application::getOptions()->snog_countryflags_log) $somecontent .= ' ::- FORWARD FOR IP: ' . $_SERVER['HTTP_FORWARDED_FOR'];
			}

			if(!empty($_SERVER['HTTP_FORWARDED']))
			{
				$ipaddress = $_SERVER['HTTP_FORWARDED'];
				if(XenForo_Application::getOptions()->snog_countryflags_log) $somecontent .= ' ::- FORWARDED IP: ' . $_SERVER['HTTP_FORWARDED'];
			}

			// FIX FOR OLD STYLE OPERA MINI PROXIES
			if(!empty($_SERVER['HTTP_X_FORWARDED_FOR']) && strpos($_SERVER['HTTP_X_FORWARDED_FOR'],','))
			{
				if(XenForo_Application::getOptions()->snog_countryflags_log) $somecontent .= ' ::- OLD STYLE OPERA CHECK: ' . $_SERVER['HTTP_X_FORWARDED_FOR'];
				$tempaddress = explode(',',$_SERVER['HTTP_X_FORWARDED_FOR']);
				foreach($tempaddress as $checkip)
				{
					if(self::isvalid_ip(trim($checkip)))
					{
						$ipaddress = trim($checkip);
						break;
					}
				}
			}else if(!empty($_SERVER['HTTP_X_FORWARDED_FOR'])){
				if(XenForo_Application::getOptions()->snog_countryflags_log) $somecontent .= ' ::- OTHER PROXY CHECK: ' . $_SERVER['HTTP_X_FORWARDED_FOR'];

				if(self::isvalid_ip($_SERVER['HTTP_X_FORWARDED_FOR']))
				{
					if(XenForo_Application::getOptions()->snog_countryflags_log) $somecontent .= ' ::- VALID CHECK: ' . $_SERVER['HTTP_X_FORWARDED_FOR'];
					$iplong = ip2long($_SERVER['HTTP_X_FORWARDED_FOR']);
					if(XenForo_Application::getOptions()->snog_countryflags_log) $somecontent .= ' ::- IP LONG: ' . $iplong;

					if((($iplong >= 167772160 && $iplong <= 184549375) && ($iplong >= 2886729728 && $iplong <= 2887778303)) || ($iplong < 167772160 || $iplong > 2887778303) && (strpos($_SERVER['HTTP_X_FORWARDED_FOR'],'192.168') !== 0))
					{
						if(XenForo_Application::getOptions()->snog_countryflags_log) $somecontent .= ' ::- FINAL PROXY CHECK: ' . $_SERVER['HTTP_X_FORWARDED_FOR'];
						$ipaddress = $_SERVER['HTTP_X_FORWARDED_FOR'];
					}
				}
			}

			if(XenForo_Application::getOptions()->snog_countryflags_log)
			{
				$filename = 'data/countryflags/ipaddress.log';
				$somecontent .= ' ::- Raw HTTP REMOTE ADDR: ' . $_SERVER['REMOTE_ADDR'];
				if(!empty($_SERVER['HTTP_CLIENT_IP']))
				{
					$somecontent .= ' ::- CLIENT IP: ' . $_SERVER['HTTP_CLIENT_IP'];
				}
				$somecontent .= ' ::- XenForo IP: ' . XenForo_Helper_Ip::convertIpBinaryToString(XenForo_Helper_Ip::getBinaryIp());
				if(isset($_SERVER['HTTP_X_FORWARDED_FOR']))
				{
					$somecontent .= ' ::- Raw X_FORWARDED: ' . $_SERVER['HTTP_X_FORWARDED_FOR'];
				}
				$somecontent .= ' ::- Result IP address: ' . $ipaddress . "\r\n";
				$handle = fopen($filename, 'a');
				fwrite($handle, $somecontent);
				fclose($handle);
			}

			if(self::isvalid_ip($ipaddress))
			{
				$temppath = realpath(__DIR__);
				$temppatha = str_ireplace('library/Snog/CountryFlags/Listener','data/countryflags/GeoLite2-Country.mmdb',$temppath);
				$temppatha = str_ireplace('library\Snog\CountryFlags\Listener','data\countryflags\GeoLite2-Country.mmdb',$temppatha);
				$request = new Zend_Controller_Request_Http; 
				$request = $request->get('REQUEST_URI'); 
				if(!stristr($request,'admin.php'))
				{
					if(!file_exists($temppatha)) return;
					$reader = new Reader($temppatha);
					$record = $reader->get($ipaddress);

					if($record)
					{
						if(isset($record['country']))
						{
							$user_flag = $record['country']['iso_code'];
						}else if(isset($record['registered_country']))
						{
							$user_flag = $record['registered_country']['iso_code'];
						}
					}
				}else{
					return;
				}
			}else{
				if($ipaddress !== 'UNKNOWN')
				{
					if(strpos($ipaddress,'10.') !== false && strpos($ipaddress,'10.') == 0)
					{
						$iplong = ip2long($ipaddress);
						if($iplong >= 167772160 && $iplong <= 184549375)
						{
							$user_flag = 'LO';
						}
					}

					if(strpos($ipaddress,'172.') !== false && strpos($ipaddress,'172.') == 0)
					{
						$iplong = ip2long($ipaddress);
						if($iplong >= 2886729728 && $iplong <= 2887778303)
						{
							$user_flag = 'LO';
						}
					}

					if(strpos($ipaddress,'192.168') !== false && strpos($ipaddress,'192.168') == 0)
					{
						$user_flag = 'LO';
					}

					if($user_flag !== 'LO')
					{
						$user_flag = 'ZZ';
					}
				}
			}

			if($visitor['snog_flag'] <> $user_flag)
			{
				$db = XenForo_Application::get('db');

				$db->query("UPDATE xf_user
					SET `snog_flag` = '" . $user_flag . "'
					WHERE `user_id` = " . $visitor['user_id'] . ""
				);
			}
		}
		return;
	}

	public static function isvalid_ip($ip, $include_priv_res = false)
	{
		return $include_priv_res ?
			filter_var($ip, FILTER_VALIDATE_IP) !== false :
			filter_var($ip, FILTER_VALIDATE_IP, FILTER_FLAG_NO_PRIV_RANGE | FILTER_FLAG_NO_RES_RANGE) !== false;
	}
}