<?php
/*======================================================================*\
|| #################################################################### ||
|| # New User Notification System  2.1
|| # Build: 25
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/


/**
 * class provides DataWriter Factory methods
 * @package Ragtek_NUNS
 */
class Ragtek_NUNS_Helper
{

    /**
     * Option to control whether or not to log the IP address of the message sender
     *
     * @var string
     */
    const OPTION_SET_IP_ADDRESS = false;

    /**
     * Option to control whether or not to log the IP address of the message sender
     *
     * @var string
     */
    const OPTION_IS_AUTOMATED = true;


    /**
     * helper to create an thread
     * @static
     * @param $user
     * @param $forumId
     * @param $subject
     * @param $message
     * @return array
     */
    public static function createThread($user, $forumId, $subject, $message)
    {
        /** @var $writer XenForo_DataWriter_Discussion_Thread */
        $writer = XenForo_DataWriter::create('XenForo_DataWriter_Discussion_Thread');
        $writer->set('user_id', $user['user_id']);
        $writer->set('username', $user['username']);

        $writer->set('title', $subject);
        $postWriter = $writer->getFirstMessageDw();
        if (self::OPTION_IS_AUTOMATED) {
            $postWriter->setOption(XenForo_DataWriter_DiscussionMessage::OPTION_IS_AUTOMATED, true);
        }


        $postWriter->set('message', $message);
        $writer->set('node_id', $forumId);
        $writer->preSave();
        $writer->save();
        return $writer->getMergedData();
    }


    /**
     * helper to create a conversation
     * @static
     * @param array $sender
     * @param array $recipients
     * @param $subject
     * @param $message
     * @param bool $noInvites
     * @param bool $conversationClosed
     * @param bool $markReadForSender
     * @return array
     */
    public static function createConversation(array $sender, array $recipients, $subject, $message,
                                              $noInvites = false, $conversationClosed = false, $markReadForSender = true)
    {
        /** @var $conversationDw XenForo_DataWriter_ConversationMaster */
        $conversationDw = XenForo_DataWriter::create('XenForo_DataWriter_ConversationMaster');
        $conversationDw->set('user_id', $sender['user_id']);
        $conversationDw->set('username', $sender['username']);
        $conversationDw->set('title', $subject);
        if ($noInvites) {
            $conversationDw->set('open_invite', 0);
        }
        if ($conversationClosed) {
            $conversationDw->set('conversation_open', 0);
        }

        $conversationDw->addRecipientUserIds($recipients);
        $messageDw = $conversationDw->getFirstMessageDw();
        if (!self::OPTION_SET_IP_ADDRESS) {
            $messageDw->setOption(XenForo_DataWriter_ConversationMessage::OPTION_SET_IP_ADDRESS, false);
        }
        $messageDw->set('message', $message);


        $conversationDw->preSave();
        $conversationDw->save();
        $conversation = $conversationDw->getMergedData();
        /** @var $convModel XenForo_Model_Conversaiont */
        $convModel = XenForo_Model::create('XenForo_Model_Conversation');
        if ($markReadForSender) {
            $convModel->markConversationAsRead(
                $conversation['conversation_id'], $sender['user_id'], XenForo_Application::$time
            );
        }

        return $conversationDw->getMergedData();
    }

    /**
     * helper to create an Profile Post
     * @static
     * @param array $sender
     * @param array $reciver
     * @param $text
     * @param string $state
     * @param bool $markRead
     * @return array
     */
    public static function createProfilePost(array $sender, array $reciver, $text, $state = 'visible', $markRead = false)
    {
        $writer = XenForo_DataWriter::create('XenForo_DataWriter_DiscussionMessage_ProfilePost');
        $writer->set('user_id', $sender['user_id']);
        $writer->set('username', $sender['username']);
        $writer->set('message', $text);
        $writer->set('profile_user_id', $reciver['user_id']);
        $writer->set('message_state', $state);
        $writer->setExtraData(XenForo_DataWriter_DiscussionMessage_ProfilePost::DATA_PROFILE_USER, $reciver);
        $writer->preSave();
        $writer->save();
        return $writer->getMergedData();
    }


    /**
     *  helper to create a post
     * @static
     * @param array $user
     * @param $threadId
     * @param $message
     * @param string $state
     * @return array
     */
    public static function createPost(array $user, $threadId, $message, $state = 'visible')
    {
        /** @var $threadModel XenForo_Model_Thread */
        $threadModel = XenForo_Model::create('XenForo_Model_Thread');
        $thread = $threadModel->getThreadById($threadId);

        $writer = XenForo_DataWriter::create('XenForo_DataWriter_DiscussionMessage_Post');
        $writer->set('user_id', $user['user_id']);
        $writer->set('username', $user['username']);
        $writer->set('message', $message);
        $writer->set('message_state', $state);
        $writer->set('thread_id', $thread['thread_id']);
        $writer->save();
        $post = $writer->getMergedData();

        return $post;
    }
}