<?php
/*======================================================================*\
|| #################################################################### ||
|| # New User Notification System  2.1
|| # Build: 25
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/


/**
 * extend xenforo userdatawriter, to run the notifications after a user was created and verified
 *
 */
class Ragtek_NUNS_DataWriter_User extends
        #XenForo_DataWriter_User
        XFCP_Ragtek_NUNS_DataWriter_User
    {

        /**
         * run the notifications
         */
        protected function _postSave()
        {

           parent::_postSave();

           if (
               (XenForo_Application::get('options')->get('registrationSetup', 'emailConfirmation') && $this->isChanged('user_state') AND $this->getExisting('user_state') == 'email_confirm')
                OR
               ($this->isInsert() AND !(XenForo_Application::get('options')->get('registrationSetup', 'emailConfirmation'))
           ))
           {
                $ph = new Ragtek_NUNS_Phrase();
                $ph->setPrefix('ragtek_NUNS_text_');

                /** @var $notificationsModel Ragtek_NUNS_Model_Notifications */
                $notificationsModel = $this->getModelFromCache('Ragtek_NUNS_Model_Notifications');
                $notificationsModel->init($ph, $this->getMergedData());

                $phraseParams = $notificationsModel->getPhraseParams();

                $ph->setParams($phraseParams);

                $notificationsModel->notify();
            }
        }
    }
