<?php

class PostReplace_Model_Post extends XenForo_Model_Post
{
	/**
	 * Fetches post that contain the given search string
	 *
	 * @param string $searchString
	 * @param array $fetchOptions
	 *
	 * @return array
	 */
	public function getPostsContaining($searchString, array $fetchOptions = array())
	{
		$limitOptions = $this->prepareLimitFetchOptions($fetchOptions);
		$joinOptions = $this->preparePostJoinOptions($fetchOptions);

		$sql = $this->limitQueryResults("
			SELECT post.*
				" . $joinOptions['selectFields'] . "
			FROM xf_post AS post
				" . $joinOptions['joinTables'] . "
			WHERE post.message LIKE " . XenForo_Db::quoteLike($searchString, 'lr') . "
			ORDER BY post.post_id
		", $limitOptions['limit'], $limitOptions['offset']);

		return $this->fetchAllKeyed($sql, 'post_id');
	}
}