<?php

class NewUserTeamNotification_Extend_DataWriter_User extends
	XFCP_NewUserTeamNotification_Extend_DataWriter_User
{
	protected function _postSave()
	{
		parent::_postSave();


		if ($this->isInsert()  && !$this->getOption(self::OPTION_ADMIN_EDIT))
		{
			$userData = $this->getMergedData();
			$options = XenForo_Application::getOptions();

			$usersArray = explode(',', $options->get('newuserteamnotification_users'));
			$usersToNotify = XenForo_Model::create('XenForo_Model_User')->getUsersByIds($usersArray);

			$geoipCountry = new XenForo_Phrase('teammail_geoip_not_available');
            $geoipCountryPhrase = $geoipCountry->render();
			if (function_exists('geoip_country_code_by_name')) {
                $geoipCountryPhrase = geoip_country_code_by_name($_SERVER['REMOTE_ADDR']);
			}

			$ip = (isset($_SERVER['REMOTE_ADDR']) ? $_SERVER['REMOTE_ADDR'] : false);

			if ($ip) {
				$host = XenForo_Model_Ip::getHost($_SERVER['REMOTE_ADDR']);
			} else {
				$host = '';
			}

			$mailParams = array(
				'boardname' => $options->boardTitle,
				'homeUrl' => ($options->homePageUrl ? $options->homePageUrl : XenForo_Link::buildPublicLink('full:index')),
				'eMail' => $userData['email'],
				'username' => $userData['username'],
				'profileurl' => XenForo_Link::buildPublicLink('full:members', $userData),
				'ip' => $ip,
				'host' => $host,
				'geoip' => $geoipCountryPhrase
			);

			foreach ($usersToNotify AS $reciver) {
				$mail = XenForo_Mail::create('newuserteammail',
					$mailParams,
					$reciver['language_id']);
				$mail->enableAllLanguagePreCache();
				$mail->queue($reciver['email'], $reciver['username']);
			}
		}
	}
}