<?php

class ModEss_XenForo_ControllerPublic_InlineMod_Post extends XFCP_ModEss_XenForo_ControllerPublic_InlineMod_Post
{
	public function actionConvertToConversation()
	{
		if ($this->isConfirmedPost())
		{
			$hardDelete = $this->_input->filterSingle('hard_delete', XenForo_Input::BOOLEAN);

			$options = array(
				'deleteType' => $hardDelete ? 'hard' : 'soft',
				'mod_message' => $this->_input->filterSingle('mod_message', XenForo_Input::STRING)
			);

			$routeUrlMatch = $this->parseRouteUrl($this->getDynamicRedirect());
			if ($routeUrlMatch && !empty($routeUrlMatch['params']['thread_id']))
			{
				$thread = $this->getModelFromCache('XenForo_Model_Thread')->getThreadById(
					$routeUrlMatch['params']['thread_id'],
					array('join' => XenForo_Model_Thread::FETCH_FORUM)
				);
				if ($thread && in_array($thread['first_post_id'], $this->getInlineModIds(false)))
				{
					$this->_request->setParam('redirect', XenForo_Link::buildPublicLink('forums', $thread));
				}
			}

			return $this->executeInlineModAction('convertPostsToConversation', $options);
		}
		else
		{
			$postIds = $this->getInlineModIds();

			$handler = $this->_getInlineModPostModel();
			if (!$handler->canConvertPostsToConversation($postIds, $errorPhraseKey))
			{
				throw $this->getErrorOrNoPermissionResponseException($errorPhraseKey);
			}

			$viewParams = array(
				'postCount' => count($postIds),
				'postIds' => $postIds
			);

			return $this->responseView('ModEss_ViewPublic_InlineMod_Post_ConvertToConversation',
				'modess_inlinemod_posts_to_conversation', $viewParams);
		}
	}
}

if (false)
{
	class XFCP_ModEss_XenForo_ControllerPublic_InlineMod_Post extends XenForo_ControllerPublic_InlineMod_Post
	{
	}
}