<?php
abstract class ModEss_Option_WarningChooser
{
    public static function renderSelect(XenForo_View $view, $fieldPrefix, array $preparedOption, $canEdit)
    {
        return self::_render('modess_warning_select', $view, $fieldPrefix, $preparedOption, $canEdit);
    }

    public static function getWarningOptions($selectedWarning)
    {
        /* @var $warningModel XenForo_Model_Warning */
        $warningModel = XenForo_Model::create('XenForo_Model_Warning');

        $warnings = $warningModel->prepareWarningDefinitions($warningModel->getWarningDefinitions());

        $options = array();

        $options[] = array(
            'value' => '',
            'label' => (string) new XenForo_Phrase('none'),
            'selected' => false
        );

        foreach ($warnings as $key => $option)
        {
            $options[$key] = array(
                'value' => $option['warning_definition_id'],
                'label' => $option['title'],
                'selected' => ($selectedWarning === $option['warning_definition_id']) ? true : false
            );
        }

        return $options;
    }
    protected static function _render($templateName, XenForo_View $view, $fieldPrefix, array $preparedOption, $canEdit)
    {
        $preparedOption['formatParams'] = self::getWarningOptions(
            $preparedOption['option_value']
        );

        return XenForo_ViewAdmin_Helper_Option::renderOptionTemplateInternal(
            $templateName, $view, $fieldPrefix, $preparedOption, $canEdit
        );
    }
}