<?php
/**
 * Permission model.
 *
 * @package ModEss
 */
class ModEss_Model_Permission extends XFCP_ModEss_Model_Permission
{
	/**
	 * Internal handler to update global or content permissions for the specified user collection.
	 *
	 * @param array $newPermissions Permissions to update, format: [permission_group_id][permission_id] => value
	 * @param array $existingEntries Existing permission entries for this collection
	 * @param integer $userGroupId
	 * @param integer $userId
	 * @param string $dwName Name of the data writer to use to insert/update data
	 * @param array $bulkData Bulk data to give to the datawriter
	 *
	 * @return boolean
	 */
	protected function _updatePermissionsForUserCollection(
		array $newPermissions, array $existingEntries, $userGroupId, $userId,
		$dwName, array $bulkData
	)
	{
		parent::_updatePermissionsForUserCollection($newPermissions, $existingEntries, $userGroupId, $userId, $dwName, $bulkData);
		
		// update the mod log count according to new permission
		// check for same permissions as Model/Thread.php canViewThreadModeratorLog()
		if (isset($newPermissions['forum']['manageAnyThread'])
			|| isset($newPermissions['forum']['editAnyPost'])
			|| isset($newPermissions['forum']['deleteAnyPost'])
			|| isset($newPermissions['forum']['deleteAnyThread'])
			|| isset($newPermissions['forum']['hardDeleteAnyPost'])
			|| isset($newPermissions['forum']['hardDeleteAnyThread'])
		)
		{
			if ($userId)
				$id = $userId;
			else
				$id = null;
			
			// update whether mod can view thread logs at all
			$this->_getModEssModel()->rebuildSessionModLogCountsCache($id, true); // true for use registry to fetch
		}
		
		return true;
	}
	
	/**
	 * @return ModEss_Model_ModEss
	 */
	protected function _getModEssModel()
	{
		return $this->getModelFromCache('ModEss_Model_ModEss');
	}
}