<?php
class ModEss_DataWriter_ModeratorDiscussion extends XenForo_DataWriter
{
    protected function _getFields()
    {
                 return array(
                    'xf_moderator_discussion' => array(
                            'discussion_id'		=> array('type' => self::TYPE_UINT,'autoIncrement' => true),
                            'thread_id'		=> array('type' => self::TYPE_INT),
                            'forum_id'		=> array('type' => self::TYPE_INT),
                            'user_id'		=> array('type' => self::TYPE_INT),
                            'discussion_thread'		=> array('type' => self::TYPE_INT),
                            'content_user_id'		=> array('type' => self::TYPE_INT),
                            'content_username'		=> array('type' => self::TYPE_STRING),
                           
                    )
            );
    }
    /**
    * Gets the actual existing data out of data that was passed in. This data
    * may be a scalar or an array. If it's a scalar, assume that it is the primary
    * key (if there is one); if it is an array, attempt to extract the primary key
    * (or some other unique identifier). Then fetch the correct data from a model.
    *
    * @param mixed Data that can uniquely ID this item
    *
    * @return array|false
    */
    protected function _getExistingData($data){
        if (!$discussId = $this->_getExistingPrimaryKey($data, 'discussion_id'))
        {
                return false;
        }

        return array('xf_moderator_discussion' => $this->_getModeratorDiscussionModel()->getDiscussionById($discussId));
    }
    
    /**
    * Gets SQL condition to update the existing record. Should read from {@link _existingData}.
    *
    * @param string Table name
    *
    * @return string
    */
    protected function _getUpdateCondition($tableName){
        return 'discussion_id = ' . $this->_db->quote($this->getExisting('discussion_id'));
        
    }
    
    /**
    * @return XenForo_Model_UserField
    */
        protected function _getModeratorDiscussionModel() {
        return $this->getModelFromCache('ModEss_Model_ModeratorDiscussion');
    }
}