<?php

/**
* Data writer for threads.
*
* @package ModEss - Sticky Thread Order
*/
class ModEss_DataWriter_Discussion_Thread extends XFCP_ModEss_DataWriter_Discussion_Thread
{
	/**
	 * Specific discussion post-save behaviors.
	 */
	protected function _discussionPostSave()
	{
		if ($this->isUpdate() && $this->isChanged('sticky') && !$this->get('sticky'))
		{
			// covers functions:
			// actionQuickUpdate() in ControllerPublic/Thread
			// actionUnstick() in  ControllerPublic/InlineMod/Thread
			$this->_getSTOModel()->deleteStickyOrder($this->get('thread_id'));
		}
		
		parent::_discussionPostSave();
	}
	
	/**
	 * Specific discussion post-delete behaviors.
	 */
	protected function _discussionPostDelete()
	{
		$this->_getSTOModel()->deleteStickyOrder($this->get('thread_id'));
		
		parent::_discussionPostDelete();
	}
	
	/**
	 * @return ModEss_Model_STO
	 */
	protected function _getSTOModel()
	{
		return $this->getModelFromCache('ModEss_Model_STO');
	}
}