<?php

class ModEss_ControllerPublic_Member extends XFCP_ModEss_ControllerPublic_Member
{
	public function actionMember()
	{
		$visitor = XenForo_Visitor::getInstance();
		$parent = parent::actionMember();
		if ($parent instanceof XenForo_ControllerResponse_View)
		{
			$user = $parent->params['user'];
			#$parent->params['modessCanViewUserNotes'] = $visitor->hasPermission('general', 'modess_viewusernotes');
			if (isset($parent->params['canBanUsers']) && $parent->params['canBanUsers'] !== true && $user['user_id'] != $visitor->getUserId() && !$user['is_admin'] && !$user['is_moderator'])
			{
				$parent->params['canBanUsers'] = $visitor->hasPermission('general', 'modess_banUsers');
			}


			$parent->params['canRevertMessages'] = $visitor->hasPermission('general', 'modess_revertEditHistory');

			/*
			if ($parent->params['modessCanViewUserNotes'])
			{
				$parent->params['modessUserNotes'] = $this->_getUserNoteModel()->getUserNotes(
					array(
						'user_id' => $parent->params['user']['user_id']
					),
					array(
						'join' => ModEss_Model_UserNote::FETCH_MODERATOR
					)
				);
				$parent->params['modessUserNotes'] = $this->_getUserNoteModel()->prepareNotes($parent->params['modessUserNotes']);
			}
			*/
		}

		return $parent;
	}

	public function actionCard()
	{
		$visitor = XenForo_Visitor::getInstance();
		$parent = parent::actionCard();
		if ($parent instanceof XenForo_ControllerResponse_View)
		{
			$user = $parent->params['user'];
			if (isset($parent->params['canBanUsers']) && $parent->params['canBanUsers'] !== true && $user['user_id'] != $visitor->getUserId() && !$user['is_admin'] && !$user['is_moderator'])
			{
				$parent->params['canBanUsers'] = $visitor->hasPermission('general', 'modess_banUsers');
			}

			$parent->params['canRevertMessages'] = $visitor->hasPermission('general', 'modess_revertEditHistory');
		}

		return $parent;
	}

	public function actionRevertMessageEdit()
	{
		$userId = $this->_input->filterSingle('user_id', XenForo_Input::UINT);
		$user = $this->getRecordOrError(
			$userId, $this->getModelFromCache('XenForo_Model_User'), 'getFullUserById',
			'requested_user_not_found'
		);

		$options = XenForo_Application::getOptions();

		if ($this->_getUserModel()
				->isUserSuperAdmin($user) || !$options->editHistory['enabled'] || !XenForo_Visitor::getInstance()
				->hasPermission('general', 'modess_revertEditHistory')
		)
		{
			return $this->responseNoPermission();
		}

		if ($this->isConfirmedPost())
		{
			$input = $this->_input->filter(array(
				'issue_warning' => XenForo_Input::BOOLEAN,
				'end_date' => XenForo_Input::DATE_TIME,
				'start_date' => XenForo_Input::DATE_TIME,
				'end_date_hour' => XenForo_Input::UINT,
				'start_date_hour' => XenForo_Input::UINT,
				'end_date_minute' => XenForo_Input::UINT,
				'start_date_minute' => XenForo_Input::UINT
			));

			$userBanned = false;

			if ($input['issue_warning'] === true && XenForo_Application::getOptions()->modess_rollback_warning)
			{
				$contentInput['content_type'] = 'user';
				$contentInput['content_id'] = $user['user_id'];

				$warningModel = $this->getModelFromCache('XenForo_Model_Warning');

				$warningHandler = $warningModel->getWarningHandler($contentInput['content_type']);
				if (!$warningHandler)
				{
					return $this->responseNoPermission();
				}

				$content = $warningHandler->getContent($contentInput['content_id']);

				if ($content && $warningHandler->canView($content) && $warningHandler->canWarn($user['user_id'],
						$content)
				)
				{
					$contentTitle = $warningHandler->getContentTitle($content);
					$contentDetails = $warningHandler->getContentDetails($content);

					$warning = $warningModel->getWarningDefinitionById(XenForo_Application::getOptions()->modess_rollback_warning);
					$warning = $warningModel->prepareWarningDefinition($warning, true);

					$replace = array(
						'{title}' => $contentTitle,
						'{content}' => $contentDetails,
						'{url}' => $warningHandler->getContentUrl($content, true),
						'{name}' => $user['username'],
						'{staff}' => XenForo_Visitor::getInstance()->username
					);
					$warning['conversationTitle'] = strtr((string)$warning['conversationTitle'], $replace);
					$warning['conversationMessage'] = strtr((string)$warning['conversationMessage'], $replace);

					$extraGroupIds = $warning['extra_user_group_ids'];

					$dwInput = array(
						'warning_definition_id' => $warning['warning_definition_id'],
						'title' => (string)$warning['title'],
						'points' => ($this->_input->filterSingle('issue_warning_points', XenForo_Input::INT)) ? $warning['points_default'] : 0,
						'notes' => '',
						'expiry_date' => (
						$warning['expiry_type'] == 'never' ? 0
							: min(
							pow(2, 32) - 1,
							strtotime('+' . $warning['expiry_default'] . ' ' . $warning['expiry_type'])
						)
						)
					);

					$conversationInput = array(
						'conversation_title' => $warning['conversationTitle'],
						'conversation_message' => $warning['conversationMessage'],
						'conversation_locked' => 0,
						'open_invite' => 0,
					);

					$dwInput += array(
						'content_type' => $contentInput['content_type'],
						'content_id' => $contentInput['content_id'],
						'content_title' => $contentTitle,
						'user_id' => $user['user_id'],
						'warning_user_id' => XenForo_Visitor::getUserId(),
						'extra_user_group_ids' => $extraGroupIds
					);

					$dw = XenForo_DataWriter::create('XenForo_DataWriter_Warning');
					$dw->bulkSet($dwInput);
					$dw->setExtraData(XenForo_DataWriter_Warning::DATA_CONTENT, $content);
					if ($warningHandler->canPubliclyDisplayWarning())
					{
						$dw->setExtraData(XenForo_DataWriter_Warning::DATA_PUBLIC_WARNING,
							$this->_input->filterSingle('public_warning', XenForo_Input::STRING)
						);
					}
					$dw->save();

					$warning = $dw->getMergedData();

					if ($conversationInput['conversation_title'] && $conversationInput['conversation_message'])
					{
						$visitor = XenForo_Visitor::getInstance();

						$conversationDw = XenForo_DataWriter::create('XenForo_DataWriter_ConversationMaster',
							XenForo_DataWriter::ERROR_SILENT);
						$conversationDw->setExtraData(XenForo_DataWriter_ConversationMaster::DATA_ACTION_USER,
							$visitor->toArray());
						$conversationDw->setExtraData(XenForo_DataWriter_ConversationMaster::DATA_MESSAGE,
							$conversationInput['conversation_message']);
						$conversationDw->bulkSet(array(
							'user_id' => $visitor['user_id'],
							'username' => $visitor['username'],
							'title' => $conversationInput['conversation_title'],
							'open_invite' => $conversationInput['open_invite'],
							'conversation_open' => ($conversationInput['conversation_locked'] ? 0 : 1),
						));
						$conversationDw->addRecipientUserIds(array($user['user_id']));

						$messageDw = $conversationDw->getFirstMessageDw();
						$messageDw->set('message', $conversationInput['conversation_message']);
						$conversationDw->save();

						$this->getModelFromCache('XenForo_Model_Conversation')->markConversationAsRead(
							$conversationDw->get('conversation_id'), XenForo_Visitor::getUserId(),
							XenForo_Application::$time
						);
					}
				}
			}

			$dateStart = $input['start_date'];
			$dateStart = $dateStart + ($input['start_date_hour'] * 60 * 60) + ($input['start_date_minute'] * 60);
			if ($options->editHistory['length'])
			{
				$dateStart = max($dateStart, XenForo_Application::$time - $options->editHistory['length'] * 86400);
			}
			$dateStart = max(0, $dateStart);

			$dateEnd = $input['end_date'];
			$dateEnd = $dateEnd + ($input['end_date_hour'] * 60 * 60) + ($input['end_date_minute'] * 60);

			$dateEnd = max(time(), $dateEnd);

			$defer = array(
				'userId' => $user['user_id'],
				'dateStart' => $dateStart,
				'dateEnd' => $dateEnd
			);

			$runner = XenForo_Deferred_Abstract::create('ModEss_Deferred_UserRevertMessageEdit');
			$runner->execute(array(), $defer, time() - 1, $status);


			return $this->responseRedirect(
				XenForo_ControllerResponse_Redirect::SUCCESS,
				XenForo_Link::buildPublicLink('members', $user),
				new XenForo_Phrase(($userBanned) ? 'modess_messages_reverted_and_user_banned' : 'modess_messages_reverted')
			);
		}

		return $this->responseView('ModEss_ViewPublic_User_RevertMessageEdit', 'modess_user_revert_message_edit', array(
			'user' => $user
		));
	}

	public function actionWarn()
	{
		XenForo_Application::set('modEss_inside_warn_action', true);

		return parent::actionWarn();
	}

	/*
	protected function _getUserNoteModel()
	{
		return $this->getModelFromCache('ModEss_Model_UserNote');
	}
	*/
}

if (false)
{
	class XFCP_ModEss_ControllerPublic_Member extends XenForo_ControllerPublic_Member
	{
	}
}