<?php

/**
 * ControllerPublic class for displaying participant groups
 *
 * @package ModEss
 */
class ModEss_ControllerPublic_Account extends XFCP_ModEss_ControllerPublic_Account
{

	/**
	 * Save user options
	 *
	 * @return XenForo_ControllerResponse_Redirect
	 */
	public function actionPreferencesSave()
	{
		$this->_assertPostOnly();
		
		$desiredType = $this->_input->filterSingle('desired_type', XenForo_Input::STRING);
		$desiredActions = array();
		
		if ($desiredType != 'none')
		{
			$actions = $this->_input->filterSingle('desired_actions', XenForo_Input::ARRAY_SIMPLE);
			
			if (empty($actions))
			{
				$desiredType = 'none';
			}
			else
			{
				foreach ($actions AS $key => $value)
				{
					$desiredActions[] = $key;
				}
				
				$desiredActions = array_unique($desiredActions);
				sort($desiredActions, SORT_STRING);
			}
		}
		
		$variables = array(
				'action_type' => $desiredType,
				'action_names' => json_encode(array_values($desiredActions))
		);
		
		$this->_getModEssModel()->setModLogPreferences(XenForo_Visitor::getUserId(), $variables);
		
		return parent::actionPreferencesSave();
	}
					
	/**
	 * @return ModEss_Model_ModEss
	 */
	protected function _getModEssModel()
	{
		return $this->getModelFromCache('ModEss_Model_ModEss');
	}
}