<?php
class ModEss_ControllerHelper_Modess extends XenForo_ControllerHelper_Abstract
{
    public function _canManageTags()
    {
        if (!(XenForo_Application::$versionId >= 1050000))
        {
            return false;
        }
        return XenForo_Visitor::getInstance()->hasPermission('general', 'modess_manageTags');
    }

    protected function _canBan(XenForo_Visitor $visitor)
    {
        if (!$visitor->hasPermission('general', 'modess_banUsers') && !$visitor->hasAdminPermission('ban'))
        {
            return false;
        }
        return true;
    }

    public function canViewBannedUsers(XenForo_Visitor $visitor)
    {
        if (!$visitor->hasPermission('general', 'modess_banUsers') && !$visitor->hasPermission('general', 'modess_viewBannedUsers') && !$visitor->hasAdminPermission('ban'))
        {
            return false;
        }
        return true;
    }

    public function canIpSearch(XenForo_Visitor $visitor)
    {
        if (!$visitor->hasPermission('general', 'modess_IpSearch'))
        {
            return false;
        }
        return true;
    }

    public function getWrapper($selectedGroup, $selectedLink, XenForo_ControllerResponse_View $subView)
    {
        $viewParams = array(
            'selectedGroup' => $selectedGroup,
            'selectedLink' => $selectedLink,
            'selectedKey' => "$selectedGroup/$selectedLink",
            'canBan' => $this->_canBan(XenForo_Visitor::getInstance()),
            'canViewBannedUsers' => $this->canViewBannedUsers(XenForo_Visitor::getInstance()),
            'canManageTags' => $this->_canManageTags(),
            'canIpSearch' => $this->canIpSearch(XenForo_Visitor::getInstance())
        );

        $wrapper = $this->_controller->responseView('ModEss_ViewPublic_Wrapper', 'modess_wrapper', $viewParams);
        $wrapper->subView = $subView;

        return $wrapper;
    }

    public static function wrap(XenForo_Controller $controller, $selectedGroup, $selectedLink, XenForo_ControllerResponse_View $subView)
    {
        $class = XenForo_Application::resolveDynamicClass(__CLASS__);
        $helper = new $class($controller);
        return $helper->getWrapper($selectedGroup, $selectedLink, $subView);
    }
}