<?php

class MetaNew_ControllerPublic_Abstract extends XenForo_ControllerPublic_Abstract
{
    public function actionIndex()
    {

        // This is largely code repurpoused from XenForo_ControllerPublic_FindNew

        $threadModel = $this->_getThreadModel();

        $userId = XenForo_Visitor::getUserId();
        $visitor = XenForo_Visitor::getInstance();

        if (!$userId)
        {
            // guests can't use this
            return $this->getNoPostsResponse();
        }


        $limitOptions = array(
            'limit' => XenForo_Application::get('options')->maximumSearchResults
        );

        // Get the unread threads
        $threadIds = $threadModel->getUnreadThreadIds($userId, $limitOptions, 0);

        // Filter by permissions
        $threads = $threadModel->getThreadsByIds(
            $threadIds,
            array(
                'join' =>
                    XenForo_Model_Thread::FETCH_FORUM |
                    XenForo_Model_Thread::FETCH_USER,
                'permissionCombinationId' => $visitor['permission_combination_id']
            )
        );

        foreach ($threads AS $key => $thread)
        {
            $thread['permissions'] = XenForo_Permission::unserializePermissions($thread['node_permission_cache']);

            if (!$threadModel->canViewThreadAndContainer($thread, $thread, $null, $thread['permissions'])
                || $visitor->isIgnoring($thread['user_id'])
            )
            {
                unset($threads[$key]);
            }
        }

        // get valid thread ids into the results
        $results = array();
        foreach ($threadIds AS $threadId)
        {
            if (isset($threads[$threadId]))
            {
                $results[] = array(
                    XenForo_Model_Search::CONTENT_TYPE => 'thread',
                    XenForo_Model_Search::CONTENT_ID => $threadId
                );
            }
        }

        if (!$results)
        {
            return $this->getNoPostsResponse();
        }

        // Extract the thread number of the last thread in the array of results
        // which is ordered by the date of the most recent change

        $last = array_slice($results, -1, 1, true);
        $the_key = key($last);

        $last_thread_number = $last[$the_key][1];

        // Return a redirect to this thread with the /unread route
        // note we just use the .number format, not thread_name.number
        // but the user will never see this, as it will get re-directed to the first unread post in the thread.
        return $this->responseRedirect(
            XenForo_ControllerResponse_Redirect::SUCCESS,
            XenForo_Link::buildPublicLink('threads/'.'.'.$last_thread_number.'/unread')
        );

    }


    public function getNoPostsResponse()
    {
        return $this->responseRedirect(
            XenForo_ControllerResponse_Redirect::SUCCESS,
            XenForo_Link::buildPublicLink('find-new/posts?recent=1')
        );
    }

    /**
     * Session activity details.
     * @see XenForo_Controller::getSessionActivityDetailsForList()
     */
    public static function getSessionActivityDetailsForList(array $activities)
    {
        return new XenForo_Phrase('viewing_latest_content');
    }

    /**
     * @return XenForo_Model_Thread
     */
    protected function _getThreadModel()
    {
        return $this->getModelFromCache('XenForo_Model_Thread');
    }

    /**
     * @return XenForo_Model_Search
     */
    protected function _getSearchModel()
    {
        return $this->getModelFromCache('XenForo_Model_Search');
    }

}