<?php

class LiamW_AlterEgoDetector_Extend_ControllerPublic_Register extends XFCP_LiamW_AlterEgoDetector_Extend_ControllerPublic_Register
{

	protected function _preDispatch($action)
	{
		parent::_preDispatch($action);

		$type = XenForo_Application::getOptions()->aedregistrationmode;
		$currentUserId = XenForo_Visitor::getUserId();

		$cookie = LiamW_AlterEgoDetector_Addon::getCookieValue();

		/* @var $session XenForo_Session */
		$session = XenForo_Application::get('session');

		if ($originalUser = $session->get('aedOriginalUser'))
		{
			$this->_debug('$inituser (in if): ' . $originalUser);
			$cookie = $originalUser;
		}

		$this->_debug('$inituser (out if): ' . $originalUser);

		if ($cookie)
		{
			if ($cookie != $currentUserId)
			{
				// AE DETECTED
				if ($type == 2)
				{
					throw $this->responseException($this->responseError(new XenForo_Phrase('new_registrations_currently_not_being_accepted')));
				}
			}
		}
	}

	public function actionRegister()
	{
		$cookie = LiamW_AlterEgoDetector_Addon::getCookieValue();

		$type = XenForo_Application::getOptions()->aedregistrationmode;
		$currentUserId = XenForo_Visitor::getUserId();

		$session = XenForo_Application::getSession();

		if ($originalUser = $session->get('aedOriginalUser'))
		{
			$this->_debug('$inituser (in if): ' . $originalUser);
			$cookie = $originalUser;
		}

		$this->_debug('$inituser (out if) actionRegister: ' . $originalUser);

		if ($cookie)
		{
			$this->_debug('Cookie true');

			if ($cookie != $currentUserId)
			{
				// AE DETECTED

				$this->_debug('Action register ae detected.');

				switch ($type)
				{
					case 0:
						$this->_debug('Action register ae detected case 0');
						break;
					case 1:
						$this->_debug('Action register ae detected case 1');
						XenForo_Application::set('aed_set_moderated', true);
						break;
					case 2:
						$this->_debug('Action register ae detected case 2');

						return $this->responseError(new XenForo_Phrase('new_registrations_currently_not_being_accepted'));
						break;
				}
			}
		}

		return parent::actionRegister();
	}

	private function _debug($message)
	{
		if (XenForo_Application::getOptions()->aeddebugmessages)
		{
			XenForo_Error::debug($message);
		}
	}

}

//class XFCP_LiamW_AlterEgoDetector_ControllerPublic_Register extends XenForo_ControllerPublic_Register {}