<?php

class LiamW_AlterEgoDetector_Extend_ControllerPublic_Login extends XFCP_LiamW_AlterEgoDetector_Extend_ControllerPublic_Login
{

	public function actionLogin()
	{
		$parent = parent::actionLogin();

		$visitor = XenForo_Visitor::getInstance();
		$originalUserId = $visitor->getUserId();
		$cookie = LiamW_AlterEgoDetector_Addon::getCookieValue();

		if (!$originalUserId)
		{
			/* @var $session XenForo_Session */
			$session = XenForo_Application::getSession();
			$session->set('aedOriginalUser', $cookie);
			$this->_debug('Session set');

			return $parent;
		}

		$options = XenForo_Application::getOptions();
		$bypassCheck = $visitor->hasPermission('general', 'aedbypass');

		$isBannedCheck = ($options->aedcheckbanned ? !$visitor->get('is_banned') : true);

		$aeDetected = false;

		$userModel = $this->_getUserModel();

		if ($cookie && !$bypassCheck && $isBannedCheck)
		{
			if ($cookie != $originalUserId)
			{
				// AE DETECTED

				$aeDetected = true;

				$this->_alterEgoDetected($cookie, $originalUserId);
			}
			$this->_debug('Line before return (1)');

			return $parent;
		}
		else if (!$bypassCheck)
		{
			// SET COOKIE
			LiamW_AlterEgoDetector_Addon::setCookieValue($originalUserId);
		}

		if (!$aeDetected && !$bypassCheck)
		{
			$ipOption = $options->aedcheckips;

			if ($ipOption['checkIp'])
			{
				$users = $userModel->getUsersByIp($_SERVER['REMOTE_ADDR']);
				if (sizeof($users) > 0)
				{
					foreach ($users as $user)
					{
						if ($user['user_id'] == $originalUserId)
						{
							continue;
						}

						if ($user['log_date'] > XenForo_Application::$time - $ipOption['minTime'] * 60)
						{
							$this->_alterEgoDetected($originalUserId, $user['user_id']);
							break;
						}
					}
				}
			}
		}

		return $parent;
	}

	protected function _alterEgoDetected($originalUserId, $alterEgoUserId)
	{
		$userModel = $this->_getUserModel();
		$options = XenForo_Application::getOptions();

		$originalUser = $userModel->getFullUserById($originalUserId);
		$alterEgoUser = $userModel->getFullUserById($alterEgoUserId);

		if (!$originalUser || !$alterEgoUser) // if any of the users don't exist, skip checking altogether and delete cookie.
		{
			LiamW_AlterEgoDetector_Addon::setCookieValue(false);

			return;
		}

		$originalUsername = $originalUser['username'];
		$alterEgoUsername = $alterEgoUser['username'];

		$userLink1 = XenForo_Link::buildPublicLink('full:members', $originalUser);
		$userLink2 = XenForo_Link::buildPublicLink('full:members', $alterEgoUser);

		$title = new XenForo_Phrase('aed_thread_subject', array(
			'username' => $alterEgoUsername
		));
		$message = new XenForo_Phrase('aed_thread_message', array(
			'username1' => $originalUsername,
			'username2' => $alterEgoUsername,
			'userLink1' => $userLink1,
			'userLink2' => $userLink2
		));

		if ($options->aedcreatethread)
		{
			/* @var $threadDw XenForo_DataWriter_Discussion_Thread */
			$threadDw = XenForo_DataWriter::create('XenForo_DataWriter_Discussion_Thread');

			$this->_debug('Initialised Thread DataWriter');

			$forumId = $options->aedforumid;
			$userId = $options->aeduserid;
			$username = $options->aedusername;

			$threadDw->bulkSet(array(
				'user_id' => $userId,
				'node_id' => $forumId,
				'title' => $title,
				'username' => $username
			));

			$firstPostDw = $threadDw->getFirstMessageDw();
			$firstPostDw->set('message', $message);

			$this->_debug('Line before thread datawriter save');
			$threadDw->save();
			$this->_debug('Thread datawriter saved');
		}

		if ($options->aedsendpm)
		{
			/* @var $conversationDw XenForo_DataWriter_ConversationMaster */
			$conversationDw = XenForo_DataWriter::create('XenForo_DataWriter_ConversationMaster');

			$this->_debug('Conversation datawriter initialised.');

			$conversationStarterId = $options->aedpmsenderid;
			$conversationStarterUsername = $options->aedpmusername;
			$conversationRecipientsOption = str_replace(array(
				"/r",
				"/r/n"
			), "/n", $options->aedpmrecipients);
			$conversationRecipients = explode("/n", $conversationRecipientsOption);

			$starterArray = $userModel->getUserById($conversationStarterId, array(
				'join' => XenForo_Model_User::FETCH_USER_FULL | XenForo_Model_User::FETCH_USER_PERMISSIONS
			));
			$starterArray['permissions'] = XenForo_Permission::unserializePermissions($starterArray['global_permission_cache']);

			if ($starterArray)
			{
				$conversationDw->setExtraData(XenForo_DataWriter_ConversationMaster::DATA_ACTION_USER,
					$starterArray);
				$conversationDw->set('user_id', $conversationStarterId);
				$conversationDw->set('username', $conversationStarterUsername);
				$conversationDw->set('title', $title);
				$conversationDw->set('open_invite', 1);
				$conversationDw->set('conversation_open', 1);
				$conversationDw->addRecipientUserNames($conversationRecipients);

				$firstMessageDw = $conversationDw->getFirstMessageDw();
				$firstMessageDw->set('message', $message);

				$this->_debug('Line before conversation save');
				$conversationDw->save();
				$this->_debug('Line after conversation save');
			}
		}

		if ($options->aedreport)
		{
			$reporterId = $options->liam_aed_reporter;

			/* @var $reportModel XenForo_Model_Report */
			$reportModel = XenForo_Model::create('XenForo_Model_Report');

			$reportModel->reportContent('alterego', array(
				$originalUser,
				$alterEgoUser
			), "These 2 users appear to be alternate egos!", $userModel->getFullUserById($reporterId));
		}

		if ($options->aedredeploycookie)
		{
			LiamW_AlterEgoDetector_Addon::setCookieValue($originalUserId);
		}
	}

	private function _debug($message)
	{
		if (XenForo_Application::getOptions()->aeddebugmessages)
		{
			XenForo_Error::debug($message);
		}
	}

}

/*class XFCP_LiamW_AlterEgoDetector_Extend_ControllerPublic_Login extends XenForo_ControllerPublic_Login
{
}*/