<?php

class GritterNotifications_Template_Callback
{
	public static function getNotifications($content, $params, XenForo_Template_Abstract $template)
	{
		/** @var $userModel XenForo_Model_User */
		$userModel = XenForo_Model::create('XenForo_Model_User');

		/** @var $notificationModel GritterNotifications_Model_Notification */
		$notificationModel = XenForo_Model::create('GritterNotifications_Model_Notification');
		$notificationModel->standardizeViewingUserReference($viewingUser);

		if (XenForo_Application::isRegistered('session'))
		{
			$dismissedNotifications = XenForo_Application::getSession()->get('dismissedNotifications');
		}

		if (!isset($dismissedNotifications) || !is_array($dismissedNotifications))
		{
			$dismissedNotifications = array();
		}

		$notifications = $notificationModel->getNotificationsFromCache();
		if (!$notifications)
		{
			$notifications = array();
		}

		$containerData = XenForo_Template_Public::getExtraContainerData();

		$_params = array_merge($template->getParams(), $containerData);
		$notificationTokens = $notificationModel->getNotificationTokens($_params, $viewingUser);

		$birthdays = array();
		$birthdayString = '';

		foreach ($notifications AS $notificationId => &$notification)
		{
			if (!in_array($notificationId, $dismissedNotifications)
				&& XenForo_Helper_Criteria::userMatchesCriteria($notification['user_criteria'], true, $viewingUser)
				&& XenForo_Helper_Criteria::pageMatchesCriteria($notification['page_criteria'], true, $_params, $containerData)
			)
			{
				$notification['valid'] = 1;
			}

			$notification['text'] = str_replace(array_keys($notificationTokens), $notificationTokens, $notification['text']);
			$notification['title'] = str_replace(array_keys($notificationTokens), $notificationTokens, $notification['title']);

			if (preg_match('{birthdays}', $notification['text']))
			{
				$dt = new DateTime('now', new DateTimeZone($viewingUser['timezone']));

				list($month, $day, $year) = explode('/', $dt->format('n/j/Y'));

				$criteria = array(
					'user_state' => 'valid',
					'is_banned' => 0
				);

				$birthdays = $userModel->getBirthdayUsers($month, $day, $criteria, array(
						'join' => XenForo_Model_User::FETCH_USER_FULL,
						'limit' => XenForo_Application::get('options')->notificationsBirthdays
					));
				if (!$birthdays)
				{
					$notifications[$notificationId]['active'] = 0;
				}
				else
				{
					$count = count($birthdays);
					$i = 0;

					foreach ($birthdays AS $birthday)
					{
						$age = 0;
						if (!empty($birthday['dob_year']))
						{
							$age = $year - $birthday['dob_year'];
						}
						$i++;
						$birthdayString = $birthdayString . XenForo_Template_Helper_Core::helperUserNameHtml($birthday, '', true) . ($age ? ' (' . $age . ')' : '') . ($i < $count ? ', ' : '');
					}
				}
			}
			if ($birthdays)
			{
				$notification['text'] = str_replace('{birthdays}', $birthdayString, $notification['text']);
			}

			$notification['rgbaPhp'] = $notificationModel->getRgbaPhpUrl($notification['custom_easy_bg']);
		}

		$viewParams = array(
			'xenOptions' => XenForo_Application::get('options')->getOptions(),
			'visitor' => $viewingUser,
			'notifications' => $notifications
		);

		return $template->create('GritterNotifications', $viewParams + $template->getParams());
	}
}