<?php

class GritterNotifications_Model_Notification extends XenForo_Model
{
	/**
	 * Fetch a single notification by its notification_id
	 *
	 * @param integer $notificationId
	 *
	 * @return array
	 */
	public function getNotificationById($notificationId)
	{
		return $this->_getDb()->fetchRow('
			SELECT *
			FROM xf_notification
			WHERE notification_id = ?
		', $notificationId);
	}
        
	public function resetNotificationById($notificationId)
	{         
		return $this->_getDb()->query('
			DELETE FROM xf_notification_dismissed
				WHERE notification_id = ?
		', $notificationId);
	}        
	
	public function getRgbaPhpUrl($colour)
	{
		if (preg_match('/rgba\((.+)\)/', $colour, $matches))
		{
			preg_match('/rgba\((.+)\)/', $colour, $matches);
			
			if($matches)
			{
				$alpha = $matches[1];
			
				$parts = explode(',', $alpha);
			
				$r = $parts[0];
				$g = $parts[1];
				$b = $parts[2];
				$a = $parts[3];
			
				$rgba = array(
						'r' => round($r),
						'g' => round($g),
						'b' => round($b),
						'a' => round($a * 255)
				);
			
				$rgbaQuery = XenForo_Link::buildQueryString($rgba);
			
				return 'rgba.php?' . $rgbaQuery;
			}
		}
		else
		{
			preg_match('/rgb\((.+)\)/', $colour, $matches);
							
			if($matches)
			{
				$alpha = $matches[1];
					
				$parts = explode(',', $alpha);
					
				$r = $parts[0];
				$g = $parts[1];
				$b = $parts[2];
				$a = '1';
					
				$rgba = array(
						'r' => round($r),
						'g' => round($g),
						'b' => round($b),
						'a' => round($a * 255)
				);
					
				$rgbaQuery = XenForo_Link::buildQueryString($rgba);
					
				return 'rgba.php?' . $rgbaQuery;
			}
		}

	}

	public function getDefaultNotification()
	{
		return array(
			'notification_id' => 0,

			'name' => '',
			'title' => '',
			'text' => '',
				
			'showtime' => '6000',
			'fadeintime' => '150',
			'fadeouttime' => '150',
			'tempclosetime' => '0',
			'delay' => '0',

			'user_criteria' => '',
			'userCriteriaList' => array(),

			'page_criteria' => '',
			'pageCriteriaList' => array(),

			'active' => 1,
			'dismissible' => 0,
			'sticky' => 0,
				
			'style' => 'gritter-dark',
			'custom_style' => '',
			'custom_easy_bg' => 'rgba(0, 0, 0, 0.85)',
			'custom_easy_text' => 'rgba(238, 238, 238, 1)',
				
			'showimage' => 'avatar',
			'image' => '',
				
			'playsound' => '0',
			'sound' => ''			
		);
	}

	/**
	 * Fetch all notifications from the database
	 *
	 * @return array
	 */
	public function getAllNotifications()
	{
		return $this->fetchAllKeyed('
			SELECT *
			FROM xf_notification
			ORDER BY notification_id
		', 'notification_id');
	}

	/**
	 * Fetch all notifications from the cache
	 *
	 * @return array
	 */
	public function getNotificationsFromCache()
	{
		return XenForo_Application::getSimpleCacheData('notifications');
	}

	/**
	 * Fetch all notifications from the database by the specified user
	 *
	 * @return array
	 */
	public function getAllNotificationsByUser($username)
	{		
		return $this->_getDb()->fetchAll('
			SELECT *
			FROM xf_notification
			WHERE create_username = ?
		', $username);
	}
	
	public function canDismissNotification(array $notification, &$errorPhraseKey = '', array $viewingUser = null)
	{
		$this->standardizeViewingUserReference($viewingUser);
	
		if (empty($viewingUser['user_id']) || empty($notification['dismissible']))
		{
			$errorPhraseKey = 'you_may_not_dismiss_this_notification';
			return false;
		}
	
		return true;
	}	
	
	public function dismissNotification($notificationId, $userId = null)
	{
		if (empty($userId))
		{
			$userId = XenForo_Visitor::getUserId();
		}
	
		if (!$userId)
		{
			return;
		}
	
		$this->_getDb()->query('
			INSERT IGNORE INTO xf_notification_dismissed
				(notification_id, user_id, dismiss_date)
			VALUES
				(?, ?, ?)
		', array($notificationId, $userId, XenForo_Application::$time));
	}
	
	public function restoreNotifications(array $user = null)
	{
		$this->standardizeViewingUserReference($user);
	
		if (!$user['user_id'])
		{
			return;
		}
	
		$db = $this->_getDb();
	
		$db->delete('xf_notification_dismissed', 'user_id = ' . $db->quote($user['user_id']));
	}	
	
	public function getDismissedNotificationIdsForUser($userId)
	{
		if (!$userId)
		{
			return array();
		}
	
		return $this->_getDb()->fetchCol('
			SELECT notification_id
			FROM xf_notification_dismissed
			WHERE user_id = ?
		', $userId);
	}	

	public function prepareNotification(array $notification)
	{
		return $notification;
	}

	public function rebuildNotificationCache()
	{
		$cache = array();

		foreach ($this->getAllNotifications() AS $notificationId => $notification)
		{
			if ($notification['active'])
			{
				$cache[$notificationId] = $notification;
			}
		}
		
		XenForo_Application::setSimpleCacheData('notifications', $cache);

		return $cache;
		
	}

	public function getNotificationTokens($params = array(), $viewingUser = array())
	{
		$this->standardizeViewingUserReference($viewingUser);

		$options = XenForo_Application::get('options');

		$notificationTokens = array(
			'{name}' => $viewingUser['username'] !== '' ? $viewingUser['username'] : new XenForo_Phrase('guest'),
			'{userid}' => $viewingUser['user_id'],
			'{boardurl}' => $options->boardUrl,
			'{boardtitle}' => $options->boardTitle,
			'{pagetitle}' => !empty($params['title'])
				? XenForo_Template_Helper_Core::jsEscape($params['title'])
				: XenForo_Template_Helper_Core::jsEscape($options->boardTitle)
		);

		if (!empty($params['forum']))
		{
			$notificationTokens = $notificationTokens + array(
				'{forumurl}' => XenForo_Link::buildPublicLink('forums', $params['forum']),
				'{forumid}' => $params['forum']['node_id'],
				'{forumname}' => $params['forum']['title']
			);
		}

		return $notificationTokens;
	}
}