<?php

class GritterNotifications_Listener
{
	public static function controllerPreDispatch(XenForo_Controller $controller, $action)
	{
		if (!XenForo_Application::isRegistered('session'))
		{
			return;
		}

		if (!$userId = XenForo_Visitor::getUserId())
		{
			return;
		}

		$session = XenForo_Application::getSession();
		if (!$session->isRegistered('dismissedNotifications'))
		{
			try
			{
				$dismissedNotifications = $notificationModel = XenForo_Model::create('GritterNotifications_Model_Notification')->getDismissedNotificationIdsForUser($userId);
			}
			catch (Exception $e)
			{
				$dismissedNotifications = array();
			}

			$session->set('dismissedNotifications', $dismissedNotifications);
		}
	}

	public static function extendAccountController($class, array &$extend)
	{
		if ($class == 'XenForo_ControllerPublic_Account')
		{
			$extend[] = 'GritterNotifications_ControllerPublic_Account';
		}
	}

	public static function templateCreate(&$templateName, array &$params, XenForo_Template_Abstract $template)
	{
		$template->preloadTemplate('GritterNotifications');
	}

	public static function addNavbarTab(array &$extraTabs, $selectedTabId)
	{
		$visitor = XenForo_Visitor::getInstance();
		$options = XenForo_Application::get('options');

		if ($options->notificationsNavTab)
		{
			if ($visitor->hasPermission('Notifications', 'canViewAllNotifications') || $visitor->hasPermission('Notifications', 'canViewOwnNotifications'))
			{
				$extraTabs['notification-center'] = array(
					'title' => new XenForo_Phrase('notification_center'),
					'href' => XenForo_Link::buildPublicLink('notification-center'),
					'linksTemplate' => 'notifications_navbar',
					'position' => 'middle',
				);
			}
		}
	}
}