<?php

class GritterNotifications_ControllerPublic_Notification extends XenForo_ControllerPublic_Abstract
{
	
	public function actionIndex()
	{
		$visitor = XenForo_Visitor::getInstance();
		$perm = $visitor->getPermissions();
		
		if(!$perm['Notifications']['canViewAllNotifications'] && !$perm['Notifications']['canViewOwnNotifications'])
		{			
			return $this->responseNoPermission();
		}
		
		if($perm['Notifications']['canViewAllNotifications'])
		{
			
			$notifications = $this->_getNotificationModel()->getAllNotifications();
				
			$viewParams = array(
					'notifications' => $notifications,
					'notificationNumber' => count($this->_getNotificationModel()->getAllNotificationsByUser($visitor['username'])),
					'notificationLimit' => $perm['Notifications']['notificationLimit'],
					'canCreateNotifications' => $perm['Notifications']['canCreateNotifications'],
			);
			
			return $this->responseView('XenForo_ViewPublic_Watched_Threads', 'notification_list_public', $viewParams);
		}
		elseif($perm['Notifications']['canViewOwnNotifications'])
		{
			$notifications = $this->_getNotificationModel()->getAllNotificationsByUser($visitor['username']);
			$viewParams = array(
					'notifications' => $notifications,
			);
			
			return $this->responseView('XenForo_ViewPublic_Watched_Threads', 'notification_list_public', $viewParams);
		}
		
	}
	
	protected function _getNotificationAddEditResponse(array $notification)
	{
		$visitor = XenForo_Visitor::getInstance();
		$perm = $visitor->getPermissions();
		
		$notificationModel = $this->_getNotificationModel();
	
		$viewParams = array(
				'notification' => $notification,
	
				'userCriteria' => XenForo_Helper_Criteria::prepareCriteriaForSelection($notification['user_criteria']),
				'userCriteriaData' => XenForo_Helper_Criteria::getDataForUserCriteriaSelection(),
	
				'pageCriteria' => XenForo_Helper_Criteria::prepareCriteriaForSelection($notification['page_criteria']),
				'pageCriteriaData' => XenForo_Helper_Criteria::getDataForPageCriteriaSelection(),
	
				'showInactiveCriteria' => true
		);
	
		return $this->responseView('GritterNotifications_ViewPublic_Notification_Edit', 'notification_edit_public', $viewParams);
	}
	
	public function actionEdit()
	{
		$visitor = XenForo_Visitor::getInstance();
		$perm = $visitor->getPermissions();
		
		$notificationId = $this->_input->filterSingle('notification_id', XenForo_Input::UINT);
		
		if (!$perm['Notifications']['canEditNotifications'] && !$perm['Notifications']['canEditOwnNotifications'])
		{
			return $this->responseNoPermission();
		}
		if ($perm['Notifications']['canEditNotifications'])
		{
			$notification = $this->_getNotificationOrError($notificationId);
			
			return $this->_getNotificationAddEditResponse($notification);
		}
		elseif($perm['Notifications']['canEditOwnNotifications'])
		{
			$notification = $this->_getNotificationOrError($notificationId);
			if($notification['create_username'] == $visitor['username'])
			{
				return $this->_getNotificationAddEditResponse($notification);
			}
			else
			{
				return $this->responseNoPermission();
			}
		}
	}
	
	/**
	 * Gets a valid notification or throws an exception.
	 *
	 * @param integer $notificationId
	 *
	 * @return array
	 */
	protected function _getNotificationOrError($notificationId)
	{
		$visitor = XenForo_Visitor::getInstance();
		$perm = $visitor->getPermissions();
		
		$notificationModel = $this->_getNotificationModel();
	
		$notification = $notificationModel->getNotificationById($notificationId);
		if (!$notification)
		{
			throw $this->responseException($this->responseError(new XenForo_Phrase('requested_notification_not_found'), 404));
		}
	
		return $notificationModel->prepareNotification($notification);
	}
	
	public function actionAdd()
	{
		$visitor = XenForo_Visitor::getInstance();
		$perm = $visitor->getPermissions();
		
		$notifications = $this->_getNotificationModel()->getAllNotificationsByUser($visitor['username']);
		$numberNotifications = count($notifications);
		
		if(!$perm['Notifications']['canCreateNotifications'])
		{
			return $this->responseNoPermission();
		}
		if($perm['Notifications']['notificationLimit'] == -1)
		{
			return $this->_getNotificationAddEditResponse($this->_getNotificationModel()->getDefaultNotification());
		}		
		elseif($numberNotifications >= $perm['Notifications']['notificationLimit'])
		{
			throw $this->responseException($this->responseError(new XenForo_Phrase('you_cannot_create_anymore_notifications')));
		}		
		
		return $this->_getNotificationAddEditResponse($this->_getNotificationModel()->getDefaultNotification());
	}
	
	public function actionPreview()
	{
		$notificationTitle = $this->_input->filterSingle('title', XenForo_Input::STRING);
		$notificationText = $this->_input->filterSingle('text', XenForo_Input::STRING);
		$notificationShowimage = $this->_input->filterSingle('showimage', XenForo_Input::STRING);
		$notificationImage = $this->_input->filterSingle('image', XenForo_Input::STRING);
		$notificationPlaysound = $this->_input->filterSingle('playsound', XenForo_Input::STRING);
		$notificationSound = $this->_input->filterSingle('sound', XenForo_Input::STRING);
		$notificationStyle = $this->_input->filterSingle('style', XenForo_Input::STRING);
		$notificationCustomstyle = $this->_input->filterSingle('custom_style', XenForo_Input::STRING);
		$notificationCustomeasytext = $this->_input->filterSingle('custom_easy_text', XenForo_Input::STRING);
		$notificationCustomeasybg = $this->_input->filterSingle('custom_easy_bg', XenForo_Input::STRING);
		$notificationShowtime = $this->_input->filterSingle('showtime', XenForo_Input::INT);
		$notificationFadeintime = $this->_input->filterSingle('fadeintime', XenForo_Input::INT);
		$notificationFadeouttime = $this->_input->filterSingle('fadeouttime', XenForo_Input::INT);
		$notificationSticky = $this->_input->filterSingle('sticky', XenForo_Input::INT);
	
		$viewParams = array(
				'title' => $notificationTitle,
				'text' => $notificationText,
				'showimage' => $notificationShowimage,
				'image' => $notificationImage,
				'playsound' => $notificationPlaysound,
				'sound' => $notificationSound,
				'style' => $notificationStyle,
				'custom_style' => $notificationCustomstyle,
				'custom_easy_text' => $notificationCustomeasytext,
				'custom_easy_bg' => $notificationCustomeasybg,
				'showtime' => $notificationShowtime,
				'fadeintime' => $notificationFadeintime,
				'fadeouttime' => $notificationFadeouttime,
				'sticky' => $notificationSticky
		);
	
		return $this->responseView('GritterNotifications_ViewPublic_Notification_Preview', 'notification_preview_public', $viewParams);
	
	}
	
	public function actionSave()
	{
		$visitor = XenForo_Visitor::getInstance();
		$this->_assertPostOnly();
	
		$notificationId = $this->_input->filterSingle('notification_id', XenForo_Input::UINT);
	
		$data = $this->_input->filter(array(
				'name' => XenForo_Input::STRING,
				'description' => XenForo_Input::STRING,
				'title' => XenForo_Input::STRING,
				'text' => XenForo_Input::STRING,
				'showimage' => XenForo_Input::STRING,
				'image' => XenForo_Input::STRING,
				'playsound' => XenForo_Input::STRING,
				'sound' => XenForo_Input::STRING,
				'active' => XenForo_Input::UINT,
				'dismissible' => XenForo_Input::UINT,
				'sticky' => XenForo_Input::UINT,
				'style' => XenForo_Input::STRING,
				'custom_style' => XenForo_Input::STRING,
				'custom_easy_bg' => XenForo_Input::STRING,
				'custom_easy_text' => XenForo_Input::STRING,
				'showtime' => XenForo_Input::INT,
				'fadeintime' => XenForo_Input::INT,
				'fadeouttime' => XenForo_Input::INT,
				'tempclosetime' => XenForo_Input::INT,
				'delay' => XenForo_Input::INT,
				'user_criteria' => XenForo_Input::ARRAY_SIMPLE,
				'page_criteria' => XenForo_Input::ARRAY_SIMPLE,
		));
	
		$dw = XenForo_DataWriter::create('GritterNotifications_DataWriter_Notification');
		
		if (!$notificationId)
		{
			$dw->set('create_date', XenForo_Application::$time);
			$dw->set('create_username', $visitor['username']);
		}
		
		if ($notificationId)
		{
			$dw->setExistingData($notificationId);
				
			$dw->set('edit_date', XenForo_Application::$time);
			$dw->set('edit_username', $visitor['username']);
		}
		
		if ($notificationId)
		{
			$dw->setExistingData($notificationId);
		}
		
		$dw->bulkSet($data);
		$dw->save();
	
		$notificationId = $dw->get('notification_id');
	
		return $this->responseRedirect(
				XenForo_ControllerResponse_Redirect::SUCCESS,
				XenForo_Link::buildPublicLink('notification-center')
		);
	}
	
	public function actionDelete()
	{
		$visitor = XenForo_Visitor::getInstance();
		$perm = $visitor->getPermissions();
		
		$notificationId = $this->_input->filterSingle('notification_id', XenForo_Input::UINT);
		
		if (!$perm['Notifications']['canDeleteNotifications'] && !$perm['Notifications']['canDeleteOwnNotifications'])
		{
			return $this->responseNoPermission();
		}
	
		if ($this->isConfirmedPost())
		{
			if ($perm['Notifications']['canDeleteNotifications'])
			{
				return $this->_deleteData(
						'GritterNotifications_DataWriter_Notification', 'notification_id',
						XenForo_Link::buildPublicLink('notification-center')
				);
			}
			elseif ($perm['Notifications']['canDeleteOwnNotifications'])
			{
				$notification = $this->_getNotificationOrError($notificationId);
				if ($notification['create_username'] == $visitor['username'])
				{
					return $this->_deleteData(
							'GritterNotifications_DataWriter_Notification', 'notification_id',
							XenForo_Link::buildPublicLink('notification-center')
					);
				}
				else
				{
					return $this->responseNoPermission();
				}
			}
		}
		else
		{
			$viewParams = array('notification' => $this->_getNotificationOrError($notificationId));
			
			if (!$perm['Notifications']['canDeleteNotifications'] && !$perm['Notifications']['canDeleteOwnNotifications'])
			{
				return $this->responseNoPermission();
			}
			
			if ($perm['Notifications']['canDeleteNotifications'])
			{
				return $this->responseView('GritterNotifications_ViewPublic_Notification_Delete', 'notification_delete_public', $viewParams);
			}
			elseif ($perm['Notifications']['canDeleteOwnNotifications'])
			{
				$notification = $this->_getNotificationOrError($notificationId);
				if ($notification['create_username'] == $visitor['username'])
				{
					return $this->responseView('GritterNotifications_ViewPublic_Notification_Delete', 'notification_delete_public', $viewParams);
				}
				else
				{
					return $this->responseNoPermission();
				}
			}
		}
	}
	
	
	/**
	 * @return XenForo_Model_Notification
	 */
	protected function _getNotificationModel()
	{
		return $this->getModelFromCache('GritterNotifications_Model_Notification');
	}
}