<?php

class GritterNotifications_ControllerPublic_Account extends XFCP_GritterNotifications_ControllerPublic_Account	
{
	
	public function actionPreferencesSave()
	{
		parent::actionPreferencesSave();
		
		if ($this->_input->filterSingle('restore_notifications', XenForo_Input::UINT))
		{
			$this->getModelFromCache('GritterNotifications_Model_Notification')->restoreNotifications();
			XenForo_Application::getSession()->set('dismissedNotifications', false);
		}
		
		return $this->responseRedirect(
				XenForo_ControllerResponse_Redirect::SUCCESS,
				XenForo_Link::buildPublicLink('account/preferences')
		);		
		
	}
	
	public function actionDismissNotification()
	{
		$this->_assertRegistrationRequired();
	
		$notificationId = $this->_input->filterSingle('notification_id', XenForo_Input::UINT);
	
		$notificationModel = $this->getModelFromCache('GritterNotifications_Model_Notification');
	
		$notification = $notificationModel->getNotificationById($notificationId);
	
		if (!$notification)
		{
			return $this->responseError(new XenForo_Phrase('requested_notification_not_found'), 404);
		}
	
		if (!$notificationModel->canDismissNotification($notification, $errorPhraseKey))
		{
			return $this->responseError(new XenForo_Phrase($errorPhraseKey));
		}
	
		if ($this->isConfirmedPost())
		{
			$notificationModel->dismissNotification($notificationId);
	
			XenForo_Application::getSession()->set('dismissedNotifications',
				$notificationModel->getDismissedNotificationIdsForUser(XenForo_Visitor::getUserId())
			);
	
			return $this->responseRedirect(
					XenForo_ControllerResponse_Redirect::SUCCESS,
					XenForo_Link::buildPublicLink('index'),
					new XenForo_Phrase('notification_dismissed')
			);
		}
		else
		{
			$viewParams = array('notification' => $notification);
	
			return $this->responseView('XenForo_ViewPublic_Account_DismissNotification', 'notification_dismiss', $viewParams);
		}
	}	
}