<?php

class GritterNotifications_ControllerAdmin_Notification extends XenForo_ControllerAdmin_Abstract
{
	protected function _preDispatch($action)
	{
		$this->assertAdminPermission('notifications');
	}

	public function actionIndex()
	{
		$notifications = $this->_getNotificationModel()->getAllNotifications();

		$optionModel = $this->getModelFromCache('XenForo_Model_Option');

		$viewParams = array(
			'notifications' => $notifications,
			'options' => $optionModel->prepareOptions($optionModel->getOptionsByIds(array('NotificationsPosition', 'NotificationsTempDismiss', 'notificationsRTE', 'notificationsModeratorBar', 'notificationsVisitorTab', 'notificationsNavTab'))),
			'canEditOptionDefinition' => $optionModel->canEditOptionAndGroupDefinitions()
		);

		return $this->responseView('XenForo_ViewAdmin_Notice_List', 'notification_list', $viewParams);
	}

	protected function _getNotificationAddEditResponse(array $notification)
	{
		$viewParams = array(
			'notification' => $notification,

			'userCriteria' => XenForo_Helper_Criteria::prepareCriteriaForSelection($notification['user_criteria']),
			'userCriteriaData' => XenForo_Helper_Criteria::getDataForUserCriteriaSelection(),

			'pageCriteria' => XenForo_Helper_Criteria::prepareCriteriaForSelection($notification['page_criteria']),
			'pageCriteriaData' => XenForo_Helper_Criteria::getDataForPageCriteriaSelection(),

			'showInactiveCriteria' => true
		);

		return $this->responseView('GritterNotifications_ViewAdmin_Notification_Edit', 'notification_edit', $viewParams);
	}

	public function actionAdd()
	{
		return $this->_getNotificationAddEditResponse($this->_getNotificationModel()->getDefaultNotification());
	}

	public function actionEdit()
	{
		$notificationId = $this->_input->filterSingle('notification_id', XenForo_Input::UINT);
		$notification = $this->_getNotificationOrError($notificationId);

		return $this->_getNotificationAddEditResponse($notification);
	}

	public function actionPreview()
	{
		$viewParams = $this->_input->filter(array(
			'title' => XenForo_Input::STRING,
			'text' => XenForo_Input::STRING,
			'showimage' => XenForo_Input::STRING,
			'image' => XenForo_Input::STRING,
			'playsound' => XenForo_Input::STRING,
			'sound' => XenForo_Input::STRING,
			'style' => XenForo_Input::STRING,
			'custom_style' => XenForo_Input::STRING,
			'custom_easy_text' => XenForo_Input::STRING,
			'custom_easy_bg' => XenForo_Input::STRING,
			'showtime' => XenForo_Input::INT,
			'fadeintime' => XenForo_Input::INT,
			'fadeouttime' => XenForo_Input::INT,
			'sticky' => XenForo_Input::INT
		));

		$notificationTokens = $this->_getNotificationModel()->getNotificationTokens(array());
		$viewParams['text'] = str_replace(array_keys($notificationTokens), $notificationTokens, $viewParams['text']);
		$viewParams['title'] = str_replace(array_keys($notificationTokens), $notificationTokens, $viewParams['title']);

		return $this->responseView('GritterNotifications_ViewAdmin_Notification_Preview', 'notification_preview', $viewParams);

	}

	public function actionSave()
	{
		$this->_assertPostOnly();

		$notificationId = $this->_input->filterSingle('notification_id', XenForo_Input::UINT);

		$data = $this->_input->filter(array(
				'name' => XenForo_Input::STRING,
				'description' => XenForo_Input::STRING,
				'title' => XenForo_Input::STRING,
				'text' => XenForo_Input::STRING,
				'showimage' => XenForo_Input::STRING,
				'image' => XenForo_Input::STRING,
				'playsound' => XenForo_Input::STRING,
				'sound' => XenForo_Input::STRING,
				'active' => XenForo_Input::UINT,
				'dismissible' => XenForo_Input::UINT,
				'sticky' => XenForo_Input::UINT,
				'style' => XenForo_Input::STRING,
				'custom_style' => XenForo_Input::STRING,
				'custom_easy_bg' => XenForo_Input::STRING,
				'custom_easy_text' => XenForo_Input::STRING,
				'showtime' => XenForo_Input::INT,
				'fadeintime' => XenForo_Input::INT,
				'fadeouttime' => XenForo_Input::INT,
				'tempclosetime' => XenForo_Input::INT,
				'delay' => XenForo_Input::INT,
				'user_criteria' => XenForo_Input::ARRAY_SIMPLE,
				'page_criteria' => XenForo_Input::ARRAY_SIMPLE
			)
		);

		$dw = XenForo_DataWriter::create('GritterNotifications_DataWriter_Notification');

		$visitor = XenForo_Visitor::getInstance();

		if (!$notificationId)
		{
			$dw->set('create_date', XenForo_Application::$time);
			$dw->set('create_username', $visitor['username']);
		}

		if ($notificationId)
		{
			$dw->setExistingData($notificationId);

			$dw->set('edit_date', XenForo_Application::$time);
			$dw->set('edit_username', $visitor['username']);
		}

		$dw->bulkSet($data);
		$dw->save();

		$notificationId = $dw->get('notification_id');

		return $this->responseRedirect(
			XenForo_ControllerResponse_Redirect::SUCCESS,
			XenForo_Link::buildAdminLink('notifications') . $this->getLastHash($notificationId)
		);
	}

	public function actionDelete()
	{
		$notificationId = $this->_input->filterSingle('notification_id', XenForo_Input::UINT);

		if ($this->isConfirmedPost())
		{
			return $this->_deleteData(
				'GritterNotifications_DataWriter_Notification', 'notification_id',
				XenForo_Link::buildAdminLink('notifications')
			);
		}
		else
		{
			$viewParams = array('notification' => $this->_getNotificationOrError($notificationId));

			return $this->responseView('GritterNotifications_ViewAdmin_Notification_Delete', 'notification_delete', $viewParams);
		}
	}

	public function actionReset()
	{
		$notificationId = $this->_input->filterSingle('notification_id', XenForo_Input::UINT);

		if ($this->isConfirmedPost())
		{
			$this->_getNotificationModel()->resetNotificationById($notificationId);

			return $this->responseRedirect(
				XenForo_ControllerResponse_Redirect::SUCCESS,
				XenForo_Link::buildAdminLink('notifications') . $this->getLastHash($notificationId)
			);
		}
		else
		{
			$viewParams = array('notification' => $this->_getNotificationOrError($notificationId));

			return $this->responseView('GritterNotifications_ViewAdmin_Notification_Reset', 'notification_reset', $viewParams);
		}
	}

	/**
	 * Selectively enables or disables specified notifications
	 *
	 * @return XenForo_ControllerResponse_Abstract
	 */
	public function actionToggle()
	{
		return $this->_getToggleResponse(
			$this->_getNotificationModel()->getAllNotifications(),
			'GritterNotifications_DataWriter_Notification',
			'notifications'
		);
	}

	/**
	 * Gets a valid notification or throws an exception.
	 *
	 * @param integer $notificationId
	 *
	 * @return array
	 */
	protected function _getNotificationOrError($notificationId)
	{
		$notificationModel = $this->_getNotificationModel();

		$notification = $notificationModel->getNotificationById($notificationId);
		if (!$notification)
		{
			throw $this->responseException($this->responseError(new XenForo_Phrase('requested_notification_not_found'), 404));
		}

		return $notificationModel->prepareNotification($notification);
	}

	/**
	 * @return GritterNotifications_Model_Notification
	 */
	protected function _getNotificationModel()
	{
		return $this->getModelFromCache('GritterNotifications_Model_Notification');
	}
}