<?php

class Dark_vB4Redir_Route_Prefix_Threads extends XFCP_Dark_vB4Redir_Route_Prefix_Threads implements XenForo_Route_Interface 
{
	public function match($routePath, Zend_Controller_Request_Http $request, XenForo_Router $router)
	{
		if(!preg_match('/\w+\.([0-9]+)\/?/', $routePath))
		{
			if(preg_match('/^([0-9]+)(?:-[^\/]+)/', $routePath, $matches) && count($matches) >= 1){			// (?:\/?$|(?:-[^\/]+))
							
				$importModel = XenForo_Model::create('XenForo_Model_Import');
				$inputHandler = new XenForo_Input(new Zend_Controller_Request_Http());
				$p = $inputHandler->filterSingle('p', XenForo_Input::UINT);
				if($p){
					$target = XenForo_Link::buildPublicLink('posts', array('post_id' => $importModel->mapPostId($p)));					
				} else {			
					$target = XenForo_Link::buildPublicLink('threads', array('thread_id' => $importModel->mapThreadId($matches[1])));		
				}
				
				$response = new Zend_Controller_Response_Http();
				$response->setRedirect(XenForo_Link::convertUriToAbsoluteUri($target), 301);
				$response->sendResponse();
				exit;
			}
		}
		
		if($this instanceof XFCP_Dark_vB4Redir_Route_Prefix_Threads)
			return parent::match($routePath, $request, $router);	
	}
}