<?php
  
class ConversationPost_Listener
{
	public static function templateHook($hookName, &$contents, array $hookParams, XenForo_Template_Abstract $template)
	{
	
		$options = XenForo_Application::getOptions();
		$post_visible = $options->post_visible;
		$userinfo_visible = $options->userinfo_visible;
		
		if ($post_visible)
		{
		    if ($hookName == 'post_private_controls')
		    {
		            $params = $template->getParams();
		            $params += $hookParams;
		            $contents = $contents . $template->create('conversationpost_post', $params);
		    }				
		} 
		
		if ($userinfo_visible)
		{
		    if ($hookName == 'message_user_info_extra')
		    {
		            $params = $template->getParams();
		            $params += $hookParams;
		            $contents = $template->create('conversationpost_userinfo', $params) . $contents;
		    }				
		} 				
		
			
	}
	
	public static function templateCreate($templateName, array &$params, XenForo_Template_Abstract $template)
	{
	    if ($templateName == 'thread_view')
	    {
			$template->preloadTemplate('conversationpost_post');
			$template->preloadTemplate('conversationpost_userinfo');
	    }		
	}	
	

    
    public static function extendPostController($class, array &$extend)
    {
            if ($class == 'XenForo_ControllerPublic_Post')
            {
                $extend[] = 'ConversationPost_ControllerPublic_Post';
            }
    }    
}