<?php

class Andy_Rsvp_DataWriter extends XFCP_Andy_Rsvp_DataWriter
{
	public function save()
	{		
		// call parent
		parent::save();
		
		// get database
		$db = XenForo_Application::get('db');		
		
		// get postId
		$currentPostId = $this->get('post_id');	
		
		// run query
		$threadId = $db->fetchOne("
		SELECT first_post_id
		FROM xf_thread
		WHERE first_post_id = " . $currentPostId . "
		");	
		
		// continue only if first post
		if ($threadId)		
		{
			// get current message
			$currentMessage = $this->get('message');		
	
			// find [/rsvp]
			$pos1 = stripos($currentMessage, '[/rsvp]');
			
			// only add if bbcode is found
			if (is_numeric($pos1))
			{
				// go to end
				$pos1 = $pos1 + 7;
				
				// get first part of message
				$currentMessage = substr($currentMessage, 0, $pos1);
				
				// run query
				$threadId = $db->fetchOne("
				SELECT thread_id
				FROM xf_thread
				WHERE first_post_id = " . $currentPostId . "
				");				
				
				// run query
				$results = $db->fetchAll("
				SELECT username, rsvp_count
				FROM xf_attendee_list
				WHERE thread_id = " . $threadId . "
				ORDER BY username ASC
				");
				
				// define variable
				$rsvpList = '';
				
				// create rsvpList
				foreach ($results as $k => $v)
				{ 
					$rsvpList = $rsvpList . $v['username'] . ' ' . $v['rsvp_count'] . '
';
				}
				
				// create new message
				$newMessage = $currentMessage . '
' . '
' . $rsvpList;
	
				//########################################
				// add total
	
				$rsvpCount = $db->fetchOne("
				SELECT SUM(rsvp_count) 
				FROM xf_rsvp
				WHERE thread_id = " . $threadId . "
				");		
				
				if ($rsvpCount != 0)
				{
					// create new message
					$newMessage = $newMessage . '
' . new XenForo_Phrase('rsvplist_total') . $rsvpCount;
				}
				
				// update xf_post
				$db->query('
				UPDATE xf_post SET
					message = ?
					WHERE post_id = ?
				', array($newMessage, $currentPostId));
			}			
	
			//#####################################
			// begin update search
			//#####################################		
			
			// delete xf_bb_code_parse_cache
			$db->query('
				DELETE FROM xf_bb_code_parse_cache
				WHERE content_id = ?
			', $currentPostId);	
			
			//########################################
			// this query is used to update 
			// xf_search_index and ElasticSearch index
			
			// run query
			$data = $db->fetchRow("
			SELECT xf_thread.node_id, 
			xf_thread.thread_id, 
			xf_thread.title, 
			xf_post.message, 
			xf_post.post_date, 
			xf_post.user_id
			FROM xf_post
			INNER JOIN xf_thread ON xf_thread.thread_id = xf_post.thread_id 
			WHERE xf_post.post_id = ?
			", $currentPostId);	
			
			// addslashes to make database safe
			$data['message'] = addslashes($data['message']);						
			
			//#####################################
			// update xf_search_index
			//#####################################				
	
			// if ElasticSearch is NOT enabled
			if (!XenForo_Application::get('options')->enableElasticsearch)
			{			
				// run query
				$db->query('
					UPDATE xf_search_index SET
						message = "' . $data['message'] . '"
					WHERE content_type = "post"
					AND content_id = ?
				', $currentPostId);
			}
			
			//#####################################
			// update ElasticSearch post index
			//#####################################
			
			// if ElasticSearch is enabled
			if (XenForo_Application::get('options')->enableElasticsearch)
			{				
				// get ElasticSearch index name
				$indexName = XenES_Api::getInstance()->getIndex();		
				
				// define variables
				$contentType = 'post';
				$contentId = $currentPostId;
				
				// define record data
				$record = array(
					'node' => $data['node_id'],
					'thread' => $data['thread_id'],
					'title' => $data['title'], 
					'message' => $data['message'],
					'date' => $data['post_date'],
					'user' => $data['user_id'],
					'discussion_id' => $currentPostId
				);
	
				// update ElasticSearch index
				XenES_Api::index($indexName, $contentType, $contentId, $record);
			}
		}
	}
}