<?php

class Andy_Rsvp_ControllerPublic_Rsvp extends XenForo_ControllerPublic_Abstract
{	
	public function actionAdd()
	{
		//########################################
		// add
		//########################################		
		
		// get userId
		$userId = XenForo_Visitor::getUserId();	
		
		// throw error if no userId
		if ($userId == '')
		{
			throw $this->getNoPermissionResponseException();
		}			
		
		// get threadId from URL
		$threadId = $this->_input->filterSingle('t', XenForo_Input::UINT);		
		
		// get database
		$db = XenForo_Application::get('db');
		
		// get first_post_id
		$results = $db->fetchRow("
		SELECT user_id, first_post_id
		FROM xf_thread
		WHERE thread_id = ?
		", $threadId);
		
		// define variable
		$firstPostId = $results['first_post_id'];
		
		// declare variable
		$authorized = '';			
		
		// get permission
		$addRemoveAll = XenForo_Visitor::getInstance()->hasPermission('rsvpGroupID', 'rsvpAddRemoveAll');
		
		// get permission
		$addRemoveOwn = XenForo_Visitor::getInstance()->hasPermission('rsvpGroupID', 'rsvpAddRemoveOwn');		
	
		// show authorized if addRemoveAll
		if ($addRemoveAll)
		{
			$authorized = 'yes';
		}			
		
		// show authorized if addRemoveOwn and thread starter
		if ($addRemoveOwn AND $userId == $results['user_id'])
		{
			$authorized = 'yes';
		}			
		
		// throw error if not authorized
		if ($authorized == '')
		{
			throw $this->getNoPermissionResponseException();
		}
		
		//########################################
		// update message 
		//########################################
		
		// get message
		$message = $db->fetchOne("
		SELECT message
		FROM xf_post
		WHERE post_id = ?
		", $firstPostId);
		
		// find exsisting rsvp code
		$pos1 = stripos($message, '[rsvp=');
		
		// if no existing code continue
		if ($pos1 === false)
		{
			// define variable
			$rsvpCode = '[rsvp=' . $threadId . ']' . new XenForo_Phrase('rsvp_click_here_to_rsvp') . '[/rsvp]';
			
			// create new message
			$newMessage = $message . '
' . '
' . $rsvpCode;
	
			// update xf_post
			$db->query('
			UPDATE xf_post SET
				message = ?
				WHERE post_id = ?
			', array($newMessage, $firstPostId));
		
			//########################################
			// begin update search
			//########################################	
			
			// define postId
			$postId = $firstPostId;	
			
			// delete xf_bb_code_parse_cache
			$db->query('
				DELETE FROM xf_bb_code_parse_cache
				WHERE content_id = ?
			', $postId);	
			
			//########################################
			// this query is used to update 
			// xf_search_index and ElasticSearch index
			
			// run query
			$data = $db->fetchRow("
			SELECT xf_thread.node_id, 
			xf_thread.thread_id, 
			xf_thread.title, 
			xf_post.message, 
			xf_post.post_date, 
			xf_post.user_id
			FROM xf_post
			INNER JOIN xf_thread ON xf_thread.thread_id = xf_post.thread_id 
			WHERE xf_post.post_id = ?
			", $postId);				
			
			//########################################
			// update xf_search_index
			//########################################				
		
			// if ElasticSearch is NOT enabled
			if (!XenForo_Application::get('options')->enableElasticsearch)
			{
				// addslashes to make database safe
				$data['message'] = addslashes($data['message']);
										
				// run query
				$db->query('
					UPDATE xf_search_index SET
						message = "' . $data['message'] . '"
					WHERE content_type = "post"
					AND content_id = ?
				', $postId);
			}
			
			//########################################
			// update ElasticSearch post index
			//########################################
			
			// if ElasticSearch is enabled
			if (XenForo_Application::get('options')->enableElasticsearch)
			{				
				// get ElasticSearch index name
				$indexName = XenES_Api::getInstance()->getIndex();		
				
				// define variables
				$contentType = 'post';
				$contentId = $postId;
				
				// define record data
				$record = array(
					'node' => $data['node_id'],
					'thread' => $data['thread_id'],
					'title' => $data['title'], 
					'message' => $data['message'],
					'date' => $data['post_date'],
					'user' => $data['user_id'],
					'discussion_id' => $postId
				);
		
				// update ElasticSearch index
				XenES_Api::index($indexName, $contentType, $contentId, $record);
			}
		}
		
		// return to thread		
		return $this->responseRedirect(
		XenForo_ControllerResponse_Redirect::SUCCESS,
		XenForo_Link::buildPublicLink('threads/' . $threadId . '/'));		
	}
	
	public function actionRegistration()
	{
		//########################################
		// registration
		//########################################
					
		// get userId
		$userId = XenForo_Visitor::getUserId();	
		
		// throw error if no userId
		if ($userId == '')
		{
			throw $this->getNoPermissionResponseException();
		}			
		
		// get threadId from URL
		$threadId = $this->_input->filterSingle('t', XenForo_Input::UINT);		
		
		// get database
		$db = XenForo_Application::get('db');
		
		// run query
		$data = $db->fetchRow("
		SELECT thread_id, post_date
		FROM xf_thread
		WHERE thread_id = " . $threadId . "
		LIMIT 1
		");	
		
		// throw error if threadId is incorrect
		if (!$data['thread_id'])
		{
			throw $this->getErrorOrNoPermissionResponseException('rsvp_thread_id_incorrect');
		}
		
		//########################################
		// check if past expire days
		//########################################		

		// get options from Admin CP -> Options -> Rsvp -> Days
		$days = XenForo_Application::get('options')->rsvpDays;
		
		// convert to Unix timesatmp
		$timestamp = time() - (86400 * $days);			

		// throw error
		if ($data['post_date'] < $timestamp)
		{
			throw $this->getErrorOrNoPermissionResponseException('rsvp_the_rsvp_for_this_event_has_ended');
		}

		//########################################
		// prepare viewParams
		//########################################

		// run query
		$username = $db->fetchOne("
		SELECT username
		FROM xf_user
		WHERE user_id = " . $userId . "
		LIMIT 1
		");	
		
		// run query
		$rsvpCount = $db->fetchOne("
		SELECT rsvp_count
		FROM xf_rsvp
		WHERE thread_id = " . $threadId . "
		AND username = ?
		", $username);				
		
		// send to template
		$viewParams = array(
			'threadId' => $threadId,
			'username' => $username,
			'rsvpCount' => $rsvpCount
		);
		
		// send to template
		return $this->responseView('Andy_Rsvp_ViewPublic_Rsvp','andy_rsvp_register', $viewParams);
	}
	
	public function actionSave()
	{
		//########################################
		// save
		//########################################
				
		// get postid from URL
		$threadId = $this->_input->filterSingle('threadId', XenForo_Input::UINT);
						
		// get visitor userId
		$userId = XenForo_Visitor::getUserId();
		
		// get count from URL
		$count = $this->_input->filterSingle('count', XenForo_Input::UINT);		
		
		// get database
		$db = XenForo_Application::get('db');
		
		// run query
		$username = $db->fetchOne("
		SELECT username
		FROM xf_user
		WHERE user_id = " . $userId . "
		LIMIT 1
		");		
		
		// delete row
		$db->query("
			DELETE FROM xf_rsvp
			WHERE thread_id = " . $threadId . "
			AND username = ?
		", $username);	
		
		// insert new row
		$db->query("
			INSERT INTO xf_rsvp
				(thread_id, username, rsvp_count)
			VALUES
				('$threadId', '$username', '$count')
		");	
		
		//########################################
		// update post
		// add rsvp list information below the
		// following [/rsvp] code
		//########################################
		
		// get first_post_id
		$firstPostId = $db->fetchOne("
		SELECT first_post_id
		FROM xf_thread
		WHERE thread_id = ?
		", $threadId);
		
		// get message
		$message = $db->fetchOne("
		SELECT message
		FROM xf_post
		WHERE post_id = ?
		", $firstPostId);				
		
		// find [/rsvp]
		$pos1 = stripos($message, '[/rsvp]');
		
		// add if bbcode is found
		if (is_numeric($pos1))
		{
			// go to end
			$pos1 = $pos1 + 7;
			
			// get first part of message
			$message = substr($message, 0, $pos1);
			
			// run query
			$results = $db->fetchAll("
			SELECT username, rsvp_count
			FROM xf_rsvp
			WHERE thread_id = " . $threadId . "
			ORDER BY username ASC
			");
			
			// define variable
			$rsvpList = '';
			
			// create attendee list
			foreach ($results as $k => $v)
			{ 
				$rsvpList = $rsvpList . $v['username'] . ' ' . $v['rsvp_count'] . '
';
			}
			
			// create new message
			$newMessage = $message . '
' . '
' . $rsvpList;

			//########################################
			// add total

			$rsvpCount = $db->fetchOne("
			SELECT SUM(rsvp_count) 
			FROM xf_rsvp
			WHERE thread_id = " . $threadId . "
			");		
			
			if ($rsvpCount != 0)
			{	
			
				// create new message
				$newMessage = $newMessage . '
' . new XenForo_Phrase('rsvp_total') . $rsvpCount;
			}
			
			// update xf_post
			$db->query('
			UPDATE xf_post SET
				message = ?
				WHERE post_id = ?
			', array($newMessage, $firstPostId));
		}
		
		//#####################################
		// begin update search
		//#####################################	
		
		// define postId
		$postId = $firstPostId;	
		
		// delete xf_bb_code_parse_cache
		$db->query('
			DELETE FROM xf_bb_code_parse_cache
			WHERE content_id = ?
		', $postId);	
		
		//########################################
		// this query is used to update 
		// xf_search_index and ElasticSearch index
		
		// run query
		$data = $db->fetchRow("
		SELECT xf_thread.node_id, 
		xf_thread.thread_id, 
		xf_thread.title, 
		xf_post.message, 
		xf_post.post_date, 
		xf_post.user_id
		FROM xf_post
		INNER JOIN xf_thread ON xf_thread.thread_id = xf_post.thread_id 
		WHERE xf_post.post_id = ?
		", $postId);				
		
		//#####################################
		// update xf_search_index
		//#####################################				

		// if ElasticSearch is NOT enabled
		if (!XenForo_Application::get('options')->enableElasticsearch)
		{
			// addslashes to make database safe
			$data['message'] = addslashes($data['message']);
									
			// run query
			$db->query('
				UPDATE xf_search_index SET
					message = "' . $data['message'] . '"
				WHERE content_type = "post"
				AND content_id = ?
			', $postId);
		}
		
		//#####################################
		// update ElasticSearch post index
		//#####################################
		
		// if ElasticSearch is enabled
		if (XenForo_Application::get('options')->enableElasticsearch)
		{				
			// get ElasticSearch index name
			$indexName = XenES_Api::getInstance()->getIndex();		
			
			// define variables
			$contentType = 'post';
			$contentId = $postId;
			
			// define record data
			$record = array(
				'node' => $data['node_id'],
				'thread' => $data['thread_id'],
				'title' => $data['title'], 
				'message' => $data['message'],
				'date' => $data['post_date'],
				'user' => $data['user_id'],
				'discussion_id' => $postId
			);

			// update ElasticSearch index
			XenES_Api::index($indexName, $contentType, $contentId, $record);
		}															

		// return to thread		
		return $this->responseRedirect(
		XenForo_ControllerResponse_Redirect::SUCCESS,
		XenForo_Link::buildPublicLink('threads/' . $threadId . '/'));		
	}
	
	public function actionDelete()
	{
		//########################################
		// delete
		//########################################
		
		// get visitor userId
		$userId = XenForo_Visitor::getUserId();	
		
		// throw error if no userId
		if ($userId == '')
		{
			throw $this->getNoPermissionResponseException();
		}
		
		// get database
		$db = XenForo_Application::get('db');
		
		// run query
		$username = $db->fetchOne("
		SELECT username
		FROM xf_user
		WHERE user_id = " . $userId . "
		LIMIT 1
		");		
				
		// get postid from URL
		$threadId = $this->_input->filterSingle('t', XenForo_Input::UINT);		

		// delete row
		$db->query("
			DELETE FROM xf_rsvp
			WHERE thread_id = " . $threadId . "
			AND username = ?
		", $username);	
		
		//########################################
		// update post
		// add rsvp list information below
		// [/rsvp]
		//########################################
		
		// get first_post_id
		$firstPostId = $db->fetchOne("
		SELECT first_post_id
		FROM xf_thread
		WHERE thread_id = ?
		", $threadId);
		
		// get message
		$message = $db->fetchOne("
		SELECT message
		FROM xf_post
		WHERE post_id = ?
		", $firstPostId);				
		
		// find [/rsvp]
		$pos1 = stripos($message, '[/rsvp]');
		
		// only add if bbcode is found
		if (is_numeric($pos1))
		{
			// go to end
			$pos1 = $pos1 + 7;
			
			// get first part of message
			$message = substr($message, 0, $pos1);
			
			// run query
			$results = $db->fetchAll("
			SELECT username, rsvp_count
			FROM xf_rsvp
			WHERE thread_id = " . $threadId . "
			ORDER BY username ASC
			");
			
			// define variable
			$rsvpList = '';
			
			// create attendee list
			foreach ($results as $k => $v)
			{ 
				$rsvpList = $rsvpList . $v['username'] . ' ' . $v['rsvp_count'] . '
';
			}
			
			// create new message
			$newMessage = $message . '
' . '
' . $rsvpList;

			//########################################
			// add total

			$rsvpCount = $db->fetchOne("
			SELECT SUM(rsvp_count) 
			FROM xf_rsvp
			WHERE thread_id = " . $threadId . "
			");	
			
			if ($rsvpCount != 0)
			{
				// create new message
				$newMessage = $newMessage . '
' . new XenForo_Phrase('rsvp_total') . $rsvpCount;
			}
			
			// update xf_post
			$db->query('
			UPDATE xf_post SET
				message = ?
				WHERE post_id = ?
			', array($newMessage, $firstPostId));
		}
		
		//#####################################
		// begin update search
		//#####################################	
		
		// define postId
		$postId = $firstPostId;	
		
		// delete xf_bb_code_parse_cache
		$db->query('
			DELETE FROM xf_bb_code_parse_cache
			WHERE content_id = ?
		', $postId);	
		
		//########################################
		// this query is used to update 
		// xf_search_index and ElasticSearch index
		
		// run query
		$data = $db->fetchRow("
		SELECT xf_thread.node_id, 
		xf_thread.thread_id, 
		xf_thread.title, 
		xf_post.message, 
		xf_post.post_date, 
		xf_post.user_id
		FROM xf_post
		INNER JOIN xf_thread ON xf_thread.thread_id = xf_post.thread_id 
		WHERE xf_post.post_id = ?
		", $postId);				
		
		//#####################################
		// update xf_search_index
		//#####################################				

		// if ElasticSearch is NOT enabled
		if (!XenForo_Application::get('options')->enableElasticsearch)
		{
			// addslashes to make database safe
			$data['message'] = addslashes($data['message']);			
						
			// run query
			$db->query('
				UPDATE xf_search_index SET
					message = "' . $data['message'] . '"
				WHERE content_type = "post"
				AND content_id = ?
			', $postId);
		}
		
		//#####################################
		// update ElasticSearch post index
		//#####################################
		
		// if ElasticSearch is enabled
		if (XenForo_Application::get('options')->enableElasticsearch)
		{				
			// get ElasticSearch index name
			$indexName = XenES_Api::getInstance()->getIndex();		
			
			// define variables
			$contentType = 'post';
			$contentId = $postId;
			
			// define record data
			$record = array(
				'node' => $data['node_id'],
				'thread' => $data['thread_id'],
				'title' => $data['title'], 
				'message' => $data['message'],
				'date' => $data['post_date'],
				'user' => $data['user_id'],
				'discussion_id' => $postId
			);

			// update ElasticSearch index
			XenES_Api::index($indexName, $contentType, $contentId, $record);
		}													

		// return to thread
		return $this->responseRedirect(
		XenForo_ControllerResponse_Redirect::SUCCESS,
		XenForo_Link::buildPublicLink('threads/' . $threadId . '/'));			
	}
}