<?php

class Andy_EmailLog_Mail extends XFCP_Andy_EmailLog_Mail
{
	public function sendMail(Zend_Mail $mailObj)
	{
		if (!XenForo_Application::get('config')->enableMail)
		{
			return true;
		}

		$transport = self::getTransport();
		$transport = self::getFinalTransportForMail($mailObj, $transport);

		try
		{
			$mailObj->send($transport);
		}
		catch (Exception $e)
		{
			$this->_failureException = $e;
			$toEmails = implode(', ', $mailObj->getRecipients());
			XenForo_Error::logException($e, false, "Email to $toEmails failed: ");
			return false;
		}
		
		//########################################
		// start hack
		//########################################
		
		// get data
		$toEmails = implode(', ', $mailObj->getRecipients());
		$subject = $mailObj->getSubject();
		$subject = substr($subject,0,199);
		$dateline = time();
		
        // get options from Admin CP -> Options -> Email Log -> Decode
        $decode = XenForo_Application::get('options')->emailLogDecode;		
		
		if ($decode)
		{
			$subject = str_replace('=?utf-8?Q?', '', $subject);
			$subject = str_replace('?=', '', $subject);
			$subject = quoted_printable_decode($subject);
		}		
		
		// get database
		$db = XenForo_Application::get('db');
		
		// insert row
		$db->query("
			INSERT INTO xf_email_log
				(email_date, email_address, email_subject)
			VALUES 
				(?,?,?)
		", array($dateline, $toEmails, $subject));	
		
		//########################################
		// end hack
		//########################################		

		return true;
	}
	
	public function queue($toEmail, $toName = '', array $headers = array(), $fromEmail = '', $fromName = '', $returnPath = '')
	{
		if (!$toEmail)
		{
			return false;
		}

		if (!XenForo_Application::get('config')->enableMail)
		{
			return true;
		}

		if (!XenForo_Application::get('config')->enableMailQueue)
		{
			return $this->send($toEmail, $toName, $headers, $fromEmail, $fromName, $returnPath);
		}

		$mailObj = $this->getPreparedMailHandler($toEmail, $toName, $headers, $fromEmail, $fromName, $returnPath);
		if (!$mailObj)
		{
			return false;
		}			
		
		//########################################
		// start hack
		//########################################
		
		// get data
		$toEmails = implode(', ', $mailObj->getRecipients());
		$subject = $mailObj->getSubject();
		$subject = substr($subject,0,199);
		
        // get options from Admin CP -> Options -> Email Log -> Decode
        $decode = XenForo_Application::get('options')->emailLogDecode;		
		
		if ($decode)
		{
			$subject = str_replace('=?utf-8?Q?', '', $subject);
			$subject = str_replace('?=', '', $subject);
			$subject = quoted_printable_decode($subject);
		}
		
		$dateline = time();
		
		// get database
		$db = XenForo_Application::get('db');
		
		// insert row
		$db->query("
			INSERT INTO xf_email_log
				(email_date, email_address, email_subject)
			VALUES 
				(?,?,?)
		", array($dateline, $toEmails, $subject));	
		
		//########################################
		// end hack
		//########################################		

		return XenForo_Model::create('XenForo_Model_MailQueue')->insertMailQueue($mailObj);
	}	
}