<?php

class Andy_EmailLog_ControllerPublic_EmailLog extends XenForo_ControllerPublic_Abstract
{	
	public function actionIndex()
	{	
		// get permission
		if (!XenForo_Visitor::getInstance()->hasPermission('emailLogGroupID', 'emailLogID'))
		{
			throw $this->getNoPermissionResponseException();
		}		
		
		// get database
		$db = XenForo_Application::get('db');
		
		// run query
		$results = $db->fetchAll("
		SELECT *
		FROM xf_email_log
		ORDER BY email_date DESC
		LIMIT 1000
		");	
		
		// declare variable
		$resultsNew = array();
		
		foreach ($results as $k => $v)
		{
			// run query
			$username = $db->fetchOne("
			SELECT username
			FROM xf_user
			WHERE email = ?
			", $v['email_address']);
			
			// create resultsNew array
			$resultsNew[] = array(
				'email_date' => $v['email_date'],
				'email_username' => $username,
				'email_address' => $v['email_address'],
				'email_subject' => $v['email_subject']
			);			
		}
		
		// rename variable
		$results = $resultsNew;
		
		// prepare viewParams
		$viewParams = array(
			'results' => $results
		); 
		
		// send to template
		return $this->responseView('Andy_EmailLog_ViewPublic_EmailLog', 'andy_emaillog', $viewParams);
	}
}