<?php

/*====================================================================*\
 || ################################################################## ||
|| #          Copyright 2014 WebMachine Technologies, Inc.          # ||
|| #                      All Rights Reserved.                      # ||
|| #  This file may not be redistributed in whole or part without   # ||
|| # written permission or explicit consent of the copyright owner. # ||
|| ################################################################## ||
\*====================================================================*/

class AVForums_Competitions_WidgetRenderer_Competitions extends WidgetFramework_WidgetRenderer
{
        public function extraPrepareTitle(array $widget)
        {
                if (empty($widget['title']))
                {
                        return new XenForo_Phrase('avforums_competitions_wf_title');
                }

                return parent::extraPrepareTitle($widget);
        }
        
        protected function _getConfiguration() {
                return array(
                        'name' => 'AVForums Competitions',
                        'options' => array(
                                'limit' => XenForo_Input::UINT,
                                'completed' => XenForo_Input::BOOLEAN
                        ),
                        'useCache' => true,
                        'cacheSeconds' => 1800,
                );
        }

        protected function _getOptionsTemplate() {
                return 'avforums_competitions_wf_options';
        }

        protected function _validateOptionValue($optionKey, &$optionValue)
        {
                switch ($optionKey)
                {
                        case 'limit':
                                if (empty($optionValue))
                                {
                                        $optionValue = 4;
                                }
                                break;
                        case 'completed':
                                if (empty($optionValue))
                                {
                                        $optionValue = 0;
                                }
                                break;
                }

                return parent::_validateOptionValue($optionKey, $optionValue);
        }
        
        protected function _getRenderTemplate(array $widget, $positionCode, array $params)
        {
                return 'avforums_competitions_wf_widget';
        }
        
        protected function _render(array $widget, $positionCode, array $params, XenForo_Template_Abstract $renderTemplateObject)
        {
                if (empty($widget['options']['limit']))
                {
                        $widget['options']['limit'] = 4;
                }

                $competitionModel = WidgetFramework_Core::getInstance()->getModelFromCache('AVForums_Competitions_Model_Competition');                
                $conditions = array(
                        'competition_state' => array(
                                'open'
                        ),
                        'competition_published' => 1
                );
                
                if (!empty($widget['options']['completed']))
                {
                        $conditions['competition_state'][] = 'completed';
                }
                
                $fetchOptions = array(
                        'limit' => $widget['options']['limit'],
                        'order' => 'force_thumbnail',
                        'direction' => 'DESC',
                );
                $competitions = $competitionModel->getCompetitions($conditions, $fetchOptions);
                $competitions = $competitionModel->prepareCompetitions($competitions);

                $renderTemplateObject->setParam('competitions', $competitions);

                return $renderTemplateObject->render();
        }
}

