<?php

class AVForums_Competitions_SitemapHandler_Competition extends XenForo_SitemapHandler_Abstract
{
	protected $_competitionsModel;

	public function getPhraseKey($key)
	{
		return 'avforums_competitions';
	}

	public function getRecords($previousLast, $limit, array $viewingUser)
	{
		$conditions = array('competition_state' => array('completed', 'open'));

		$competitionModel = $this->_getCompetitionModel();
		$ids = $competitionModel->getCompetitionIdsInRange($previousLast, $limit);

		if (!$ids)
		{
			return array();
		}

		$conditions['competition_id'] = $ids;
		$competitions = $competitionModel->getCompetitions($conditions);
		ksort($competitions);

		return $competitions;
	}

	public function isIncluded(array $entry, array $viewingUser)
	{
		return $entry['competition_published'] == 0 ? false : true;
	}

	public function getData(array $entry)
	{
		$entry['title'] = XenForo_Helper_String::censorString($entry['competition_title']);

		return array(
			'loc' => XenForo_Link::buildPublicLink('canonical:competitions', $entry),
			'lastmod' => $entry['competition_date']
		);
	}

	public function isInterruptable()
	{
		return true;
	}

	public function basePermissionCheck(array $viewingUser)
	{
		return XenForo_Permission::hasPermission($viewingUser['permissions'], 'competitions', 'view');
	}

	/**
	 * @return AVForums_Competitions_Model_Competition
	 */
	protected function _getCompetitionModel()
	{
		if (!$this->_competitionsModel)
		{
			$this->_competitionsModel = XenForo_Model::create('AVForums_Competitions_Model_Competition');
		}

		return $this->_competitionsModel;
	}
}