<?php

class AVForums_Competitions_Listener
{
	public static function visitorSetup(XenForo_Visitor &$visitor)
	{
		$visitor->offsetSet('competition_entries', @unserialize($visitor->get('competition_entries')));
	}

	public static function navigationTabs(array &$extraTabs, $selectedTabId)
	{
		$visitor = XenForo_Visitor::getInstance();
		$options = XenForo_Application::get('options');

		if ($visitor->hasPermission('competitions', 'view')
			&& $options->get('competitionNavTab')
		)
		{
			$competitions = XenForo_Application::getSimpleCacheData('competitionsCacheFull');

			$count = 0;
			if ($competitions && $options->get('competitionTabCount'))
			{
				$enteredCompetitions = $visitor->get('competition_entries');

				if (isset($enteredCompetitions['hash']))
				{
					unset($enteredCompetitions['hash']);
				}

				if ($enteredCompetitions)
				{
					foreach ($enteredCompetitions AS $entered)
					{
						if (!empty($competitions[$entered['competition_id']]))
						{
							unset ($competitions[$entered['competition_id']]);
						}
					}
				}

				$count = count($competitions);

				if ($count < 0)
				{
					$count = 0;
				}
			}

			$extraTabs['competitions'] = array(
				'title' => new XenForo_Phrase('avforums_competitions'),
				'href' => XenForo_Link::buildPublicLink('full:competitions'),
				'position' => 'middle',
				'linksTemplate' => 'avforums_competitions_tab_links',
				'counter' => $count
			);
		}
	}

	public static function extendThreadController($class, array &$extend)
	{
		$extend[] = 'AVForums_Competitions_ControllerPublic_Thread';
	}

	public static function extendMemberController($class, array &$extend)
	{
		$extend[] = 'AVForums_Competitions_ControllerPublic_Member';
	}

	public static function extendMemberView($class, array &$extend)
	{
		$extend[] = 'AVForums_Competitions_ViewPublic_Member_View';
	}

	public static function extendUserDataWriter($class, array &$extend)
	{
		$extend[] = 'AVForums_Competitions_DataWriter_User';
	}
	
	public static function extendWidgetFamework(array &$renderers)
	{
	    $renderers[] = 'AVForums_Competitions_WidgetRenderer_Competitions';
	}
	
}