<?php

/**
 * Cron entries for AVForums.com Competitions
 */
class AVForums_Competitions_CronEntry_Competitions
{
	/**
	 * Opens, closes and de-publishes competitions based on the start and end date.
	 */
	public static function changeCompetitionState()
	{
		$db = XenForo_Application::getDb();
		XenForo_Db::beginTransaction($db);

		/* @var $competitionModel AVForums_Competitions_Model_Competition */
		$competitionModel = XenForo_Model::create('AVForums_Competitions_Model_Competition');

		$runTime = XenForo_Application::$time + $competitionModel->getTimeDifference();

		$conditions = array(
			'competition_state' => array(
				'closed', 'open'
			),
			'competition_published' => 1,
			'routineRun' => true
		);
		$competitions = $competitionModel->getCompetitions($conditions);

		$updates = array();
		foreach ($competitions AS $competitionId => $competition)
		{
			if ($runTime > $competition['competition_start'] && $competition['competition_state'] == 'closed')
			{
				$updates[$competitionId]['competition_state'] = 'open';
			}
			// Deactivate this if you want to manually open the competitions
			elseif ($runTime < $competition['competition_start'] && $competition['competition_state'] == 'open')
			{
				$updates[$competitionId]['competition_state'] = 'closed';
			}

			if ($runTime > $competition['competition_end'] && $competition['competition_state'] == 'open')
			{
				$updates[$competitionId]['competition_state'] = 'closed';
			}

			if ($runTime > $competition['competition_end'] + (86400 * XenForo_Application::getOptions()->competitionDateThreshold))
			{
				$updates[$competitionId]['competition_published'] = 0;
			}
		}

		foreach ($updates AS $competitionId => $update)
		{
			$competitionWriter = XenForo_DataWriter::create('AVForums_Competitions_DataWriter_Competition');

			$competitionWriter->setExistingData($competitionId);
			foreach ($update AS $column => $data)
			{
				$competitionWriter->set($column, $data);
			}

			$competitionWriter->save();
		}

		XenForo_Db::commit($db);

		self::generateCompetitionWinners();
	}

	/**
	 * Chooses the winners of any closed competitions that do not yet have winners.
	 */
	public static function generateCompetitionWinners()
	{
		$db = XenForo_Application::getDb();
		XenForo_Db::beginTransaction($db);

		/* @var $competitionModel AVForums_Competitions_Model_Competition */
		$competitionModel = XenForo_Model::create('AVForums_Competitions_Model_Competition');

		$conditions = array(
			'end_date' => XenForo_Application::$time + $competitionModel->getTimeDifference(),
			'competition_state' => 'closed',
			'pickingWinners' => true
		);
		$competitions = $competitionModel->getCompetitions($conditions);

		/* @var $entryModel AVForums_Competitions_Model_Entry */
		$entryModel = XenForo_Model::create('AVForums_Competitions_Model_Entry');

		$entryConditions = array(
			'answer_state' => 'correct',
			'entry_state' => 'loser',
			'user_state' => 'valid'
		);
		$entryFetchOptions = array(
			'join' => AVForums_Competitions_Model_Entry::FETCH_USER,
			'order' => 'rand'
		);

		foreach ($competitions AS $competition)
		{
			if ($competition['external_link'] != '')
			{
				$competitionWriter = XenForo_DataWriter::create('AVForums_Competitions_DataWriter_Competition');

				$competitionWriter->setExistingData($competition['competition_id']);
				$competitionWriter->bulkSet(array(
					'competition_state' => 'completed'
				));

				$competitionWriter->save();
			}
			else
			{
				$entryConditions['competition_id'] = $competition['competition_id'];

				$winners = array();
				$runnersUp = array();

				if ($competition['number_of_winners'] > 0)
				{
					$entryFetchOptions['limit'] = $competition['number_of_winners'];

					$winners = $entryModel->getEntries($entryConditions, $entryFetchOptions, 'user_id');

					foreach ($winners AS $winner)
					{
						$db->update('xf_avforums_competitions_entry', array('entry_state' => 'winner'), 'entry_id = ' . $db->quote($winner['entry_id']));
					}
				}

				if ($competition['number_of_runners_up'] > 0)
				{
					$entryFetchOptions['limit'] = $competition['number_of_runners_up'];

					$runnersUp = $entryModel->getEntries($entryConditions, $entryFetchOptions, 'user_id');

					foreach ($runnersUp AS $runnerUp)
					{
						$db->update('xf_avforums_competitions_entry', array('entry_state' => 'runner_up'), 'entry_id = ' . $db->quote($runnerUp['entry_id']));
					}
				}

				$competitionWinners = array(
					'winners' => $winners,
					'runnersUp' => $runnersUp
				);

				$competitionWriter = XenForo_DataWriter::create('AVForums_Competitions_DataWriter_Competition');

				$competitionWriter->setExistingData($competition['competition_id']);
				$competitionWriter->bulkSet(array(
					'competition_state' => 'completed',
					'competition_winners' => $competitionWinners
				));

				$competitionWriter->save();
			}
		}

		XenForo_Db::commit($db);
	}
}