<?php

class AVForums_Competitions_ControllerPublic_Member extends XFCP_AVForums_Competitions_ControllerPublic_Member
{
	public function actionCompetitions()
	{
		$userId = $this->_input->filterSingle('user_id', XenForo_Input::UINT);
		$user = $this->getHelper('UserProfile')->assertUserProfileValidAndViewable($userId);

		$competitionModel = $this->_getCompetitionModel();

		if (!$competitionModel->canViewCompetitions())
		{
			return $this->responseNoPermission();
		}

		$competitions = array();

		$competitionEntries = @unserialize($user['competition_entries']);
		if ($competitionEntries)
		{
			$competitionIds = array();
			foreach ($competitionEntries AS $entry)
			{
				$competitionIds[] = $entry['competition_id'];
			}

			$conditions = array(
				'competition_id' => $competitionIds
			);

			$fetchOptions = array(
				'join' => AVForums_Competitions_Model_Competition::FETCH_USER
			);

			$competitions = $competitionModel->getCompetitions($conditions, $fetchOptions);
			$competitions = $competitionModel->prepareCompetitions($competitions, true);
		}

		$viewParams = array(
			'user' => $user,
			'competitions' => $competitions,
			'competitionEntries' => $competitionEntries
		);
		return $this->responseView('AVForums_Competitions_ViewPublic_Member', 'avforums_competitions_member_view', $viewParams);
	}

	/**
	 * @return AVForums_Competitions_Model_Competition
	 */
	protected function _getCompetitionModel()
	{
		return $this->getModelFromCache('AVForums_Competitions_Model_Competition');
	}
}