/** @param {jQuery} $ jQuery Object */
!function($, window, document, _undefined)
{
	XenForo.ImageUploader = function($container)
	{
		var uploader = XenForo.AttachmentUploader($container);

		var $result = $($container.data('result')),
			$uploaderId = $container.data('uploaderid'),
			$type = $container.data('type'),
			$width = $container.data('width'),
			$height = $container.data('height'),
			$fixed = $container.data('fixed'),
			$progress = $result.find('.Progress_' + $uploaderId),
			$meter = $progress.find('.Meter_' + $uploaderId),
			$filename = $result.find('.Filename_' + $uploaderId),
			$delete = $result.find('.Delete_' + $uploaderId),
			$image = $('.Image_' + $uploaderId),
			$imageData = $('.ImageData_' + $uploaderId),
			$imageData = $('.ImageData_' + $uploaderId),
			$thumbContainer = $('.ThumbContainer_' + $uploaderId),
			$currentThumbContainer = $('.CurrentContainer_' + $uploaderId),
			$currentCaptionContainer = $('.CurrentCaption_' + $uploaderId),
			$currentUrlContainer = $('.CurrentUrl_' + $uploaderId),
			$currentAltTitleContainer = $('.CurrentAltTitle_' + $uploaderId),
			$thumb = $('.Thumb_' + $uploaderId),
			queueLength = 0,
			swfUpload,
			fileId,

			showContainer = function()
			{
				$container.css(
				{
					overflow: '',
					height: '',
					width: '',
					position: ''
				});
			},
			hideContainer = function()
			{
				$container.css(
				{
					overflow: 'hidden',
					height: '1px',
					width: '1px',
					position: 'relative'
				});
			},
			showPreview = function(coords)
			{
				var image = $('.Image_' + $uploaderId + ' img');

				var rx = $width / coords.w;
				var ry = $height / coords.h;

				$('.Thumb_' + $uploaderId + ' img').css({
					width: Math.round(rx * image.width()) + 'px',
					height: Math.round(ry * image.height()) + 'px',
					marginLeft: '-' + Math.round(rx * coords.x) + 'px',
					marginTop: '-' + Math.round(ry * coords.y) + 'px'
				});

				$('#' + $uploaderId + 'SelX1').val(coords.x);
				$('#' + $uploaderId + 'SelY1').val(coords.y);
				$('#' + $uploaderId + 'SelX2').val(coords.x2);
				$('#' + $uploaderId + 'SelY2').val(coords.y2);
				$('#' + $uploaderId + 'SelWidth').val(coords.w);
				$('#' + $uploaderId + 'SelHeight').val(coords.h);
			},
			removeCoords = function()
			{
				$JcropApi.setSelect([0,0,0,0]);
				return false;
			},

			attachmentErrorHandler = function(e)
			{
				swfUpload = e.swfUpload;
				fileId = null;

				setTimeout(function() {
					if (!$filename.is(':visible'))
					{
						var error = '';
						if (e.ajaxData)
						{
							$.each(e.ajaxData.error, function(i, errorText) { error += errorText + "\n"; });
						}

						uploader.swfAlert(e.file, e.errorCode, error);

						$('#' + e.file.id).xfRemove();
						$result.hide();
						showContainer();
					}
				}, 1000);

				if (e.type == 'AttachmentUploadError')
				{
					queueLength--;
				}
			};

		$container.bind(
		{
			AttachmentQueueValidation: function(e)
			{
				swfUpload = e.swfUpload;

				if (queueLength > 1)
				{
					e.preventDefault();
					e.swfUpload.cancelUpload(e.file.id, false);
					return;
				}

				fileId = e.file.id;
			},

			AttachmentQueued: function(e)
			{
				swfUpload = e.swfUpload

				if (queueLength > 1)
				{
					e.swfUpload.cancelUpload(e.file.id, false);
					return;
				}

				fileId = e.file.id;

				queueLength++;

				console.log('Queued: %s (%d bytes)', e.file.name, e.file.size);

				hideContainer();
				$filename.hide();
				$meter.css('width', 0);
				$progress.show();
				$result.fadeIn(XenForo.speed.fast);
			},

			AttachmentUploadProgress: function(e)
			{
				swfUpload = e.swfUpload;
				fileId = e.file.id;

				console.log('Uploaded %d/%d bytes.', e.bytes, e.file.size);

				var percent = Math.min(100, Math.ceil(e.bytes * 100 / e.file.size));

				$meter.css('width', percent + '%');
			},

			AttachmentQueueError: attachmentErrorHandler,
			AttachmentUploadError: attachmentErrorHandler,

			AttachmentUploaded: function(e)
			{
				swfUpload = e.swfUpload;
				fileId = null;

				var filename = e.ajaxData.filename || e.file.name;
				console.info('Upload of %s completed!', filename);

				$currentThumbContainer.hide();
				$currentCaptionContainer.remove();
				$currentUrlContainer.remove();
				$currentAltTitleContainer.remove();
				hideContainer();
				$result.show();
				$progress.hide();
				$filename.text(filename);
				$filename.show();
				$imageData.show();

				if (e.ajaxData.viewUrl)
				{
					$image.prepend('<img src="' + e.ajaxData.viewUrl + '" />');
					$image.show();

					var form = $image.closest("form");

					form.append('<input type="hidden" name="new_' + $type + '" value="1" />');

					$thumbContainer.show();

					$thumb.prepend('<img src="' + e.ajaxData.viewUrl + '" />');
					$thumb.show();

					if (!$fixed)
					{
						$width = 0;
						$height = 0;
					}

					$('.Image_' + $uploaderId + ' img').Jcrop({
						aspectRatio: $width / $height,
						onChange: showPreview,
						onSelect: showPreview,
						onRelease: removeCoords,
						keySupport: false
					},
					function()
					{
						$JcropApi = this;
					});
				}

				$delete.data('href', e.ajaxData.deleteUrl);

				if (e.file)
				{
					// only do the queue for the swf upload
					queueLength--;
				}
			}
		});

		$delete.bind('click', function(e)
		{
			e.preventDefault();
			console.log(e);

			if ($delete.data('href'))
			{
				XenForo.ajax(
					$delete.data('href'), {},
					function(ajaxData, textStatus)
					{
						$delete.removeData('href');
						$result.fadeOut(XenForo.speed.fast, function()
						{
							showContainer();
							$('.Image_' + $uploaderId + ' img').xfRemove();
							$image.hide();
							$('.Thumb_' + $uploaderId + ' img').xfRemove();
							$thumbContainer.hide();
							$imageData.hide();

							removeCoords();
						});
					}
				);
			}
			else
			{
				if (swfUpload && fileId)
				{
					swfUpload.cancelUpload(fileId);
				}
				$result.fadeOut(XenForo.speed.fast, function()
				{
					showContainer();
				});
			}

			$JcropApi.destroy();
		});
	};

	// *********************************************************************

	if (typeof XenForo.AttachmentUploader == 'function')
	{
		XenForo.register('.ImageUploader', 'XenForo.ImageUploader');
	}
}
(jQuery, this, document);