/**
* @package XenCentral Framework
* @author Skydevelop EU
* @copyright Drnoyan & Nalyan LDA, Portugal, EU
* @license http://www.dnf.pt/eula.html
* @link http://www.skydevelop.com
* @version 1.4.1
* @revision 125
*/
/** @param {jQuery} $ jQuery Object */
!function ($, window, document, _undefined) {
    /**
     * Censor word listener for the options page. This handles automatically
     * creating additional text boxes when necessary.
     *
     * @param jQuery li.CensorWordOptionListener to listen to
     */
    XenForo.CensorWordOptionListenerExtended = function ($element) {
        this.__construct($element);
    };

    XenForo.CensorWordOptionListenerExtended.prototype =
    {
        __construct: function ($element) {
            $element.one('keydown', $.context(this, 'createChoice'));

            this.$element = $element;
            if (!this.$base) {
                this.$base = $element.clone();
            }
        },

        lastCall: 0,

        createChoiceDelayed: function (e) {
            if (e.which && e.which < 47) {
                return;
            }
            if ((new Date()).getTime() - this.lastCall < 1000) {
                return;
            }
            this.lastCall = (new Date()).getTime();
            this.createChoice();
        },

        createChoice: function (e) {
            // skip the event if tab key
            var keyCode = e.keyCode || e.which;

            if (keyCode == 9 || keyCode == 17 || keyCode == 16) {
                $(this.$element).one('keydown', $.context(this, 'createChoice'));
                return true;
            }

            var $new = this.$base.clone(),
                nextCounter = this.$element.parent().children().length;

            var maxCount = this.$element.parent().data('max');

            if (
                maxCount &&
                nextCounter >= maxCount
            ) {
                return;
            }

            $new.find('[name]').each(function () {
                var $this = $(this);
                $this.attr('name', $this.attr('name').replace(/\[(\d+)\]/, '[' + nextCounter + ']'));
            });

            $new.find('*[id]').each(function () {
                var $this = $(this);
                $this.removeAttr('id');
                XenForo.uniqueId($this);

                if (XenForo.formCtrl) {
                    XenForo.formCtrl.clean($this);
                }
            });

            $new.xfInsert('insertAfter', this.$element);

            this.__construct($new);
        }
    };

    // *********************************************************************

    XenForo.register('li.CensorWordOptionListenerExtended', 'XenForo.CensorWordOptionListenerExtended');

}
(jQuery, this, document);