/**
* @package XenCentral Framework
* @author Skydevelop EU
* @copyright Drnoyan & Nalyan LDA, Portugal, EU
* @license http://www.dnf.pt/eula.html
* @link http://www.skydevelop.com
* @version 1.4.1
* @revision 125
*/
/**
 * @version 1.0.0
 * jQuery Plugin allowing to implement comet technology
 */
(function($){
    $.fn.SkyDevRecursiveAjax = function(options){
        this.defaults = {
            restartInterval: 10000,
            timeout: 30000
        };
        
        this.options = $.extend(this.defaults, options);
        
        var obj = this;
        
        return this.each(function(){
            var elem = this;
            
            if ($(elem).data('SkyDevRecursiveAjax')) {
                // already registered
                return;
            }
            
            $(elem).data('SkyDevRecursiveAjax', obj);
            
            $(elem).data('lastUpdate', 0);
            
            methods.run.apply(elem);
        });
    };
    
    var methods = {
        run: function(){
            var elem = this;
            
            var obj = $(elem).data('SkyDevRecursiveAjax');
            
            var options = $.extend(true, {}, obj.options);
            
            options.complete = function(jqXHR, status){
                if (obj.options.complete) {
                    if (obj.options.context) {
                        var ctx = obj.options.context;
                    }
                    else {
                        var ctx = elem;
                    }
                    obj.options.complete.apply(ctx, [jqXHR, status]);
                }
                
                if (status == 'success' || status == 'notmodified') {
                    $(elem).data('lastUpdate', (new Date()).getTime() / 1000.0);
                }
                
                setTimeout(function(){
                    methods.run.apply(elem);
                }, options.restartInterval);
            };
            
            options.data = $.extend(options.data, {
                lastUpdate: $(elem).data('lastUpdate')
            });
            
            $.ajax(options);
        }
    };
})(jQuery);
