/**
* @package XenCentral Framework
* @author Skydevelop EU
* @copyright Drnoyan & Nalyan LDA, Portugal, EU
* @license http://www.dnf.pt/eula.html
* @link http://www.skydevelop.com
* @version 1.4.1
* @revision 125
*/
/**
 * @version 1.0.0
 * jQuery Plugin allowing to implement comet technology
 */
(function($){
    $.fn.SkyDevComet = function(options){
        this.defaults = {
            restartInterval: 10000,
            timeout: 30000,
			ajaxCallInterval:5000,
	        updateData:false, // function will be called on each run with data as argument
	        preventRun:false // function will be called on each run and cycle will be skipped if the function return true
        };

        this.options = $.extend(this.defaults, options);

        var obj = this;

		$(document).bind({
		    ajaxStart: function(e){
				if ($(obj).data('callStarted')) {
					$(obj).data('callStarted', 0);
					setTimeout(function(){
						$(document).trigger('ajaxStop');
					}, 20);
				}
		    }
		});

        return this.each(function(){
            var elem = this;

            if ($(elem).data('SkyDevComet')) {
                // already registered
                return;
            }

            $(elem).data('SkyDevComet', obj);

            $(elem).data('lastUpdate', 0);

            methods.run.apply(elem);
        });
    };

    var methods = {
        run: function(){
            var elem = this;

            var obj = $(elem).data('SkyDevComet');

            var options = $.extend(true, {}, obj.options);

            if(typeof(obj.options.preventRun)==='function') {
		        var prevent=obj.options.preventRun.apply(obj);
		        if(prevent) {
			        console.log('prevented');
			         setTimeout(function(){
						methods.run.apply(elem);
					}, options.ajaxCallInterval);
			        return true;
		        }
	        }
	        
            options.success = function(data){

				if(data.lastUpdateDate) {
					$(elem).data('lastUpdate', data.lastUpdateDate);
				} else {
					$(elem).data('lastUpdate', Math.floor((new Date()).getTime()/1000));
				}

				if (obj.options.success) {
                    if (obj.options.context) {
                        var ctx = obj.options.context;
                    }
                    else {
                        var ctx = elem;
                    }
                    obj.options.success.apply(ctx, [data]);
                }
			};
            options.complete = function(jqXHR, status){
				if (status == 'success' || status == 'notmodified') {
                    if (options.ajaxCallInterval) {
                        setTimeout(function () {
                            methods.run.apply(elem);
                        }, options.ajaxCallInterval);
                    }
                }
                else {
                    if(options.restartInterval) {
                        setTimeout(function () {
                            methods.run.apply(elem);
                        }, options.restartInterval);
                    }
                }

                if (obj.options.complete) {
                    if (obj.options.context) {
                        var ctx = obj.options.context;
                    }
                    else {
                        var ctx = elem;
                    }
                    obj.options.complete.apply(ctx, [jqXHR, status]);
                }
            };

            options.data = $.extend(options.data, {
                lastUpdate: $(elem).data('lastUpdate'),
				randkey:  Math.floor(Math.random()*$(elem).data('lastUpdate'))
            });

	        if(typeof(obj.options.updateData)==='function') {
		        options.data=obj.options.updateData.apply(obj, [options.data]);
	        }

            $(obj).data('callStarted', 1);

            $.ajax(options);
        }
    };
})(jQuery);
