/**
* @package XenCentral Framework
* @author Skydevelop EU
* @copyright Drnoyan & Nalyan LDA, Portugal, EU
* @license http://www.dnf.pt/eula.html
* @link http://www.skydevelop.com
* @version 1.4.1
* @revision 125
*/
/**
 * @param tabDefination object containing tab titles from left to right
 * @param tabId unique ID to use for these tabs
 */
function SkyDevAdminOptions(tabDefination, tabId) {
    // create tabs list
    var $tabList=$('<ul class="tabs mainTabs Tabs" data-panes="#'+ tabId+' > fieldset" data-history="on"></ul>');
    for(var tabTitleIndex in tabDefination) {
        var tabTitle= tabDefination[tabTitleIndex];
        $('<li><a href="'+requestUri+'#'+ tabId+'Tab'+ tabTitleIndex+'">'+ tabTitle+'</a></li>').appendTo($tabList);
    }
    $tabList.insertBefore('fieldset.optionList:first');

    // create tab container
    var $tabContainer = $('<div id="' + tabId + '"></div>');
    $tabContainer.insertBefore('fieldset.optionList:first');

    $('fieldset.optionList').each(function(index, el){
        $(el).attr('id', tabId + 'Tab' + index);
        $(el).appendTo($tabContainer);
    });
}