/**
* @package XenCentral Ad Server
* @author Skydevelop EU
* @copyright Drnoyan & Nalyan LDA, Portugal, EU
* @license http://www.dnf.pt/eula.html
* @link http://www.skydevelop.com
* @revision 33
* @version 1.3.3.1
*/
(function (jQuerySource, coreScriptSource) {
    if (typeof window.ad_server_loaded == "undefined") {
        window.ad_server_loaded = false;
        window.ad_server_jquery_loaded = false;
        window.ad_server_core_loaded = false;
        window.ad_server_timeout = window.setInterval(function () {
            if (typeof jQuery!='undefined' && typeof XenCentral_AdServer_Core!='undefined') {
                // both scripts are loaded now
                window.ad_server_loaded = true;
                window.clearInterval(window.ad_server_timeout);
            }
        }, 100);
    }
    function loadjQuery() {
        if (typeof jQuery == "undefined") {
            if (window.ad_server_jquery_loaded == false) {
                window.ad_server_jquery_loaded = true;
                var adServerJQueryScript = document.createElement("script");
                adServerJQueryScript.src = jQuerySource;
                adServerJQueryScript.onload = function () {
                    loadCore();
                }
                document.getElementsByTagName("head")[0].appendChild(adServerJQueryScript);
            }
        } else {
            window.ad_server_jquery_loaded = true;
            loadCore();
        }
    }
    function loadCore() {
        if (typeof XenCentral_AdServer_Core == "undefined") {
            if (window.ad_server_core_loaded == false) {
                window.ad_server_core_loaded = true;
                var adServerCoreScript = document.createElement("script");
                adServerCoreScript.src = coreScriptSource;
                document.getElementsByTagName("head")[0].appendChild(adServerCoreScript);
            }
        } else {
            window.ad_server_core_loaded = true;
        }
    }
    if(window.ad_server_loaded==false) {
        loadjQuery();
    }
})(adServerjQuerySource, adServerCoreScriptSource);
(function(zoneCode, reloadTimeout, zoneId){
    var loadScriptInterval=window.setInterval(function(){
        if(window.ad_server_loaded==false) {
            return;
        }
        // remove the timeout
        window.clearInterval(loadScriptInterval);
        try {
            $("#"+zoneId).html(zoneCode);
        } catch (ex) {
            console.log(ex.message);
        }
        if (reloadTimeout) {
            var interval=setInterval(function () {
                if(!XenCentral_AdServer_Core.pageIsActive) {
                    return;
                }
                clearInterval(interval);
                var src = $("#script_"+zoneId).attr("src");
                src = src.replace(/&t=\d+/, "");
                src += "&t=" + (new Date()).getTime();
                var head = document.getElementsByTagName("head")[0];
                var script = document.createElement("script");
                script.src = src;
                head.appendChild(script);
            }, reloadTimeout);
        }
    }, 200);
})(zoneCode, reloadTimeout, zoneId);