<?php

$startTime = microtime(true);

$fileDir = dirname(__FILE__);
if (file_exists($fileDir . '/301config.php'))
{
	include($fileDir . '/301config.php');
}

require($fileDir . '/library/XenForo/Autoloader.php');
XenForo_Autoloader::getInstance()->setupAutoloader($fileDir . '/library');

XenForo_Application::initialize($fileDir . '/library', $fileDir);
XenForo_Application::set('page_start_time', $startTime);

$inputHandler = new XenForo_Input(new Zend_Controller_Request_Http());

$input = $inputHandler->filter(array(
	'attachmentid' => XenForo_Input::UINT,
	'thumb' => XenForo_Input::UINT
));

$target = false;
if ($input['attachmentid'])
{
	$importModel = XenForo_Model::create('XenForo_Model_Import');

	if ($newId = $importModel->mapAttachmentId($input['attachmentid']))
	{
		if ($input['thumb'])
		{
			/* @var $attachmentModel XenForo_Model_Attachment */
			$attachmentModel = XenForo_Model::create('XenForo_Model_Attachment');

			if ($attachment = $attachmentModel->getAttachmentById($input['attachmentid']))
			{
				$target = XenForo_Link::convertUriToAbsoluteUri($attachmentModel->getAttachmentThumbnailUrl($attachment));
			}
		}
		else
		{
			$target = XenForo_Link::buildPublicLink('canonical:attachments', array('attachment_id' => $newId));
		}
	}
}

if (!$target)
{
	$target = XenForo_Link::buildPublicLink('canonical:index');
}

$response = new Zend_Controller_Response_Http();
$response->setRedirect(XenForo_Link::convertUriToAbsoluteUri($target), 301);
$response->sendResponse();