<?php

class Waindigo_MultipleChoice_Listener_LoadClass extends Waindigo_Listener_LoadClass
{

    protected function _getExtendedClasses()
    {
        return array(
            'Waindigo_MultipleChoice' => array(
                'controller' => array(
                    'Waindigo_CustomFields_ControllerAdmin_ThreadField',
                    'Waindigo_CustomFields_ControllerAdmin_SocialForumField',
                    'Waindigo_CustomPostFields_ControllerAdmin_PostField',
                    'XenForo_ControllerAdmin_UserField',
                    'XenResource_ControllerAdmin_Field'
                ), /* END 'controller' */
                'datawriter' => array(
                    'Waindigo_CustomFields_DataWriter_ThreadField',
                    'Waindigo_CustomFields_DataWriter_SocialForumField',
                    'Waindigo_CustomPostFields_DataWriter_PostField',
                    'XenForo_DataWriter_UserField',
                    'XenResource_DataWriter_ResourceField'
                ), /* END 'datawriter' */
                'installer_waindigo' => array(
                    'Waindigo_CustomFields_Install_Controller',
                    'Waindigo_CustomPostFields_Install_Controller'
                ), /* END 'installer_waindigo' */
            ), /* END 'Waindigo_MultipleChoice' */
        );
    } /* END _getExtendedClasses */

    public static function loadClassController($class, array &$extend)
    {
        $extend = self::createAndRun('Waindigo_MultipleChoice_Listener_LoadClass', $class, $extend, 'controller');
    } /* END loadClassController */

    public static function loadClassDataWriter($class, array &$extend)
    {
        $extend = self::createAndRun('Waindigo_MultipleChoice_Listener_LoadClass', $class, $extend, 'datawriter');
    } /* END loadClassDataWriter */

    public static function loadClassInstallerWaindigo($class, array &$extend)
    {
        $extend = self::createAndRun('Waindigo_MultipleChoice_Listener_LoadClass', $class, $extend, 'installer_waindigo');
    } /* END loadClassInstallerWaindigo */
}